/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.ConnectController;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.BeanNameViewResolver;

@Configuration
@ConditionalOnClass(value={ConnectController.class, SocialConfigurerAdapter.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class SocialWebAutoConfiguration {

    @Configuration
    @EnableSocial
    @ConditionalOnWebApplication
    protected static class SocialAutoConfigurationAdapter
    extends SocialConfigurerAdapter {
        protected SocialAutoConfigurationAdapter() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectController.class})
        public ConnectController connectController(ConnectionFactoryLocator connectionFactoryLocator, ConnectionRepository connectionRepository) {
            return new ConnectController(connectionFactoryLocator, connectionRepository);
        }

        @Bean
        @ConditionalOnMissingBean(value={BeanNameViewResolver.class})
        @ConditionalOnProperty(prefix="spring.social.", value={"auto-connection-views"})
        public ViewResolver beanNameViewResolver() {
            BeanNameViewResolver bnvr = new BeanNameViewResolver();
            bnvr.setOrder(Integer.MIN_VALUE);
            return bnvr;
        }

        public UserIdSource getUserIdSource() {
            return new UserIdSource(){

                public String getUserId() {
                    return "anonymous";
                }
            };
        }
    }
}

