/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EnableWebSecurity.class})
@ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
@ConditionalOnWebApplication
public class SpringBootWebSecurityConfiguration {
    private static List<String> DEFAULT_IGNORED = Arrays.asList("/css/**", "/js/**", "/images/**", "/**/favicon.ico");

    @Bean
    @ConditionalOnMissingBean(value={IgnoredPathsWebSecurityConfigurerAdapter.class})
    public WebSecurityConfigurer<WebSecurity> ignoredPathsWebSecurityConfigurerAdapter() {
        return new IgnoredPathsWebSecurityConfigurerAdapter();
    }

    public static void configureHeaders(HeadersConfigurer<?> configurer, SecurityProperties.Headers headers) throws Exception {
        if (headers.getHsts() != SecurityProperties.Headers.HSTS.NONE) {
            boolean includeSubdomains = headers.getHsts() == SecurityProperties.Headers.HSTS.ALL;
            HstsHeaderWriter writer = new HstsHeaderWriter(includeSubdomains);
            writer.setRequestMatcher(AnyRequestMatcher.INSTANCE);
            configurer.addHeaderWriter((HeaderWriter)writer);
        }
        if (headers.isContentType()) {
            configurer.contentTypeOptions();
        }
        if (headers.isXss()) {
            configurer.xssProtection();
        }
        if (headers.isCache()) {
            configurer.cacheControl();
        }
        if (headers.isFrame()) {
            configurer.frameOptions();
        }
    }

    public static List<String> getIgnored(SecurityProperties security) {
        ArrayList<String> ignored = new ArrayList<String>(security.getIgnored());
        if (ignored.isEmpty()) {
            ignored.addAll(DEFAULT_IGNORED);
        } else if (ignored.contains("none")) {
            ignored.remove("none");
        }
        return ignored;
    }

    @ConditionalOnExpression(value="${security.basic.enabled:true}")
    @Configuration
    @Order(value=0x7FFFFFFA)
    protected static class ApplicationWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private SecurityProperties security;

        protected ApplicationWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            if (this.security.isRequireSsl()) {
                ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
            }
            if (!this.security.isEnableCsrf()) {
                http.csrf().disable();
            }
            http.sessionManagement().sessionCreationPolicy(this.security.getSessions());
            SpringBootWebSecurityConfiguration.configureHeaders(http.headers(), this.security.getHeaders());
            String[] paths = this.getSecureApplicationPaths();
            if (paths.length > 0) {
                http.exceptionHandling().authenticationEntryPoint(this.entryPoint());
                http.httpBasic();
                http.requestMatchers().antMatchers(paths);
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasAnyRole(this.security.getUser().getRole().toArray(new String[0]));
            }
        }

        private String[] getSecureApplicationPaths() {
            ArrayList<String> list = new ArrayList<String>();
            for (String path : this.security.getBasic().getPath()) {
                String string = path = path == null ? "" : path.trim();
                if (path.equals("/**")) {
                    return new String[]{path};
                }
                if (path.equals("")) continue;
                list.add(path);
            }
            return list.toArray(new String[list.size()]);
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }
    }

    @ConditionalOnExpression(value="!${security.basic.enabled:true}")
    @Configuration
    @Order(value=0x7FFFFFFA)
    protected static class ApplicationNoWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        protected ApplicationNoWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            http.requestMatcher(new RequestMatcher(){

                public boolean matches(HttpServletRequest request) {
                    return false;
                }
            });
        }
    }

    @ConditionalOnMissingBean(value={WebMvcSecurityConfigurationConditions.class})
    @ConditionalOnMissingClass(name={"org.springframework.web.servlet.support.RequestDataValueProcessor"})
    @Configuration
    @EnableWebSecurity
    protected static class DefaultWebSecurityConfiguration {
        protected DefaultWebSecurityConfiguration() {
        }
    }

    @ConditionalOnClass(value={RequestDataValueProcessor.class})
    @ConditionalOnMissingBean(value={RequestDataValueProcessor.class})
    @Configuration
    protected static class WebMvcSecurityConfigurationConditions {
        protected WebMvcSecurityConfigurationConditions() {
        }

        @Configuration
        @EnableWebMvcSecurity
        protected static class DefaultWebMvcSecurityConfiguration {
            protected DefaultWebMvcSecurityConfiguration() {
            }
        }
    }

    @Order(value=-2147483648)
    private static class IgnoredPathsWebSecurityConfigurerAdapter
    implements WebSecurityConfigurer<WebSecurity> {
        @Autowired
        private SecurityProperties security;
        @Autowired
        private ServerProperties server;

        private IgnoredPathsWebSecurityConfigurerAdapter() {
        }

        public void configure(WebSecurity builder) throws Exception {
        }

        public void init(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            List<String> ignored = SpringBootWebSecurityConfiguration.getIgnored(this.security);
            String[] paths = this.server.getPathsArray(ignored);
            ignoring.antMatchers(paths);
        }
    }
}

