/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
@Order(value=0x7FFFFFFC)
public class AuthenticationManagerConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
    @Autowired
    private List<SecurityPrequisite> dependencies;
    @Autowired
    private ObjectPostProcessor<Object> objectPostProcessor;
    @Autowired
    private SecurityProperties security;
    @Autowired
    private AuthenticationEventPublisher authenticationEventPublisher;
    private BootDefaultingAuthenticationConfigurerAdapter configurer = new BootDefaultingAuthenticationConfigurerAdapter();

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply((SecurityConfigurer)this.configurer);
    }

    @Bean
    @Primary
    public AuthenticationManager authenticationManager() {
        return this.lazyAuthenticationManager();
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    protected AuthenticationManager lazyAuthenticationManager() {
        AuthenticationManager manager = (AuthenticationManager)this.configurer.getAuthenticationManagerBuilder().getOrBuild();
        if (manager instanceof ProviderManager) {
            ((ProviderManager)manager).setAuthenticationEventPublisher(this.authenticationEventPublisher);
        }
        return manager;
    }

    private class BootDefaultingAuthenticationConfigurerAdapter
    extends GlobalAuthenticationConfigurerAdapter {
        private AuthenticationManagerBuilder defaultAuth;

        private BootDefaultingAuthenticationConfigurerAdapter() {
        }

        public AuthenticationManagerBuilder getAuthenticationManagerBuilder() {
            return this.defaultAuth;
        }

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                this.defaultAuth = auth;
                return;
            }
            SecurityProperties.User user = AuthenticationManagerConfiguration.this.security.getUser();
            if (user.isDefaultPassword()) {
                logger.info((Object)("\n\nUsing default security password: " + user.getPassword() + "\n\n"));
            }
            this.defaultAuth = new AuthenticationManagerBuilder(AuthenticationManagerConfiguration.this.objectPostProcessor);
            LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
            AuthenticationManager parent = (AuthenticationManager)((AuthenticationManagerBuilder)((InMemoryUserDetailsManagerConfigurer)this.defaultAuth.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()])).and()).and()).build();
            auth.parentAuthenticationManager(parent);
        }
    }
}

