/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializer;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializerPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDataSourceConfiguration;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvidersConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@EnableConfigurationProperties(value={DataSourceProperties.class})
@Import(value={DataSourceInitializerPostProcessor.Registrar.class, DataSourcePoolMetadataProvidersConfiguration.class})
public class DataSourceAutoConfiguration {
    public static boolean containsAutoConfiguredDataSource(ConfigurableListableBeanFactory beanFactory) {
        try {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition("dataSource");
            return EmbeddedDataSourceConfiguration.class.getName().equals(beanDefinition.getFactoryBeanName());
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    @Order(value=0x7FFFFFF5)
    static class DataSourceAvailableCondition
    extends SpringBootCondition {
        private final SpringBootCondition nonEmbedded = new NonEmbeddedDataSourceCondition();
        private final SpringBootCondition embeddedCondition = new EmbeddedDataSourceCondition();

        DataSourceAvailableCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.hasBean(context, DataSource.class) || this.hasBean(context, XADataSource.class)) {
                return ConditionOutcome.match("existing bean configured database detected");
            }
            if (this.anyMatches(context, metadata, this.nonEmbedded, this.embeddedCondition)) {
                return ConditionOutcome.match("existing auto database detected");
            }
            return ConditionOutcome.noMatch("no existing bean configured database");
        }

        private boolean hasBean(ConditionContext context, Class<?> type) {
            return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), type, (boolean)true, (boolean)false).length > 0;
        }
    }

    static class EmbeddedDataSourceCondition
    extends SpringBootCondition {
        private final SpringBootCondition nonEmbedded = new NonEmbeddedDataSourceCondition();

        EmbeddedDataSourceCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.anyMatches(context, metadata, this.nonEmbedded)) {
                return ConditionOutcome.noMatch("existing non-embedded database detected");
            }
            EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(context.getClassLoader()).getType();
            if (type == null) {
                return ConditionOutcome.noMatch("no embedded database detected");
            }
            return ConditionOutcome.match("embedded database " + type + " detected");
        }
    }

    static class NonEmbeddedDataSourceCondition
    extends SpringBootCondition {
        NonEmbeddedDataSourceCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.getDataSourceClassLoader(context) != null) {
                return ConditionOutcome.match("supported DataSource class found");
            }
            return ConditionOutcome.noMatch("missing supported DataSource");
        }

        private ClassLoader getDataSourceClassLoader(ConditionContext context) {
            Class<? extends DataSource> dataSourceClass = new DataSourceBuilder(context.getClassLoader()).findType();
            return dataSourceClass == null ? null : dataSourceClass.getClassLoader();
        }
    }

    @Configuration
    @Conditional(value={DataSourceAvailableCondition.class})
    protected static class JdbcTemplateConfiguration {
        @Autowired(required=false)
        private DataSource dataSource;

        protected JdbcTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JdbcOperations.class})
        public JdbcTemplate jdbcTemplate() {
            return new JdbcTemplate(this.dataSource);
        }

        @Bean
        @ConditionalOnMissingBean(value={NamedParameterJdbcOperations.class})
        public NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
            return new NamedParameterJdbcTemplate(this.dataSource);
        }
    }

    @Conditional(value={NonEmbeddedDataSourceCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    protected static class NonEmbeddedConfiguration {
        @Autowired
        private DataSourceProperties properties;

        protected NonEmbeddedConfiguration() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource")
        public DataSource dataSource() {
            DataSourceBuilder factory = DataSourceBuilder.create(this.properties.getClassLoader()).driverClassName(this.properties.getDriverClassName()).url(this.properties.getUrl()).username(this.properties.getUsername()).password(this.properties.getPassword());
            return factory.build();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={DataSourceInitializer.class})
    protected static class DataSourceInitializerConfiguration {
        protected DataSourceInitializerConfiguration() {
        }

        @Bean
        public DataSourceInitializer dataSourceInitializer() {
            return new DataSourceInitializer();
        }
    }

    @Conditional(value={EmbeddedDataSourceCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @Import(value={EmbeddedDataSourceConfiguration.class})
    protected static class EmbeddedConfiguration {
        protected EmbeddedConfiguration() {
        }
    }
}

