/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OnPropertyCondition
extends SpringBootCondition {
    OnPropertyCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnProperty.class.getName()));
        String prefix = annotationAttributes.getString("prefix").trim();
        if (StringUtils.hasText((String)prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String havingValue = annotationAttributes.getString("havingValue");
        String[] names = this.getNames((Map<String, Object>)annotationAttributes);
        boolean relaxedNames = annotationAttributes.getBoolean("relaxedNames");
        boolean matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        Environment resolver = context.getEnvironment();
        if (relaxedNames) {
            resolver = new RelaxedPropertyResolver((PropertyResolver)resolver, prefix);
        }
        ArrayList<String> missingProperties = new ArrayList<String>();
        ArrayList<String> nonMatchingProperties = new ArrayList<String>();
        for (String name : names) {
            String key;
            String string = key = relaxedNames ? name : prefix + name;
            if (resolver.containsProperty(key)) {
                if (this.isMatch(resolver.getProperty(key), havingValue)) continue;
                nonMatchingProperties.add(name);
                continue;
            }
            if (matchIfMissing) continue;
            missingProperties.add(name);
        }
        if (missingProperties.isEmpty() && nonMatchingProperties.isEmpty()) {
            return ConditionOutcome.match();
        }
        StringBuilder message = new StringBuilder("@ConditionalOnProperty ");
        if (!missingProperties.isEmpty()) {
            message.append("missing required properties " + this.expandNames(prefix, missingProperties) + " ");
        }
        if (!nonMatchingProperties.isEmpty()) {
            String expected = havingValue == null ? "!false" : havingValue;
            message.append("expected '").append(expected).append("' for properties ").append(this.expandNames(prefix, nonMatchingProperties));
        }
        return ConditionOutcome.noMatch(message.toString());
    }

    private String[] getNames(Map<String, Object> annotationAttributes) {
        String[] value = (String[])annotationAttributes.get("value");
        String[] name = (String[])annotationAttributes.get("name");
        Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnProperty must be specified");
        Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnProperty are exclusive");
        return value.length > 0 ? value : name;
    }

    private boolean isMatch(String value, String requiredValue) {
        if (StringUtils.hasLength((String)requiredValue)) {
            return requiredValue.equalsIgnoreCase(value);
        }
        return !"false".equalsIgnoreCase(value);
    }

    private String expandNames(String prefix, List<String> names) {
        StringBuffer expanded = new StringBuffer();
        for (String name : names) {
            expanded.append(expanded.length() == 0 ? "" : ", ");
            expanded.append(prefix);
            expanded.append(name);
        }
        return expanded.toString();
    }
}

