/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import javax.naming.NamingException;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.util.StringUtils;

@Order(value=2147483627)
class OnJndiCondition
extends SpringBootCondition {
    OnJndiCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnJndi.class.getName()));
        String[] locations = annotationAttributes.getStringArray("value");
        try {
            return this.getMatchOutcome(locations);
        }
        catch (NoClassDefFoundError ex) {
            return ConditionOutcome.noMatch("JNDI class not found");
        }
    }

    private ConditionOutcome getMatchOutcome(String[] locations) {
        if (!this.isJndiAvailable()) {
            return ConditionOutcome.noMatch("JNDI environment is not available");
        }
        if (locations.length == 0) {
            return ConditionOutcome.match("JNDI environment is available");
        }
        JndiLocator locator = this.getJndiLocator(locations);
        String location = locator.lookupFirstLocation();
        if (location != null) {
            return ConditionOutcome.match("JNDI location '" + location + "' found from candidates " + StringUtils.arrayToCommaDelimitedString((Object[])locations));
        }
        return ConditionOutcome.noMatch("No JNDI location found from candidates " + StringUtils.arrayToCommaDelimitedString((Object[])locations));
    }

    protected boolean isJndiAvailable() {
        return JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable();
    }

    protected JndiLocator getJndiLocator(String[] locations) {
        return new JndiLocator(locations);
    }

    protected static class JndiLocator
    extends JndiLocatorSupport {
        private String[] locations;

        public JndiLocator(String[] locations) {
            this.locations = locations;
        }

        public String lookupFirstLocation() {
            for (String location : this.locations) {
                try {
                    this.lookup(location);
                    return location;
                }
                catch (NamingException ex) {
                }
            }
            return null;
        }
    }
}

