/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.BeanTypeRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    private static final Log logger = LogFactory.getLog(OnBeanCondition.class);
    private static final String[] NO_BEANS = new String[0];
    public static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";

    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<String> matching;
        BeanSearchSpec spec;
        StringBuffer matchMessage = new StringBuffer();
        if (metadata.isAnnotated(ConditionalOnBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnBean " + spec + " found no beans");
            }
            matchMessage.append("@ConditionalOnBean " + spec + " found the following " + matching);
        }
        if (metadata.isAnnotated(ConditionalOnSingleCandidate.class.getName())) {
            spec = new SingleCandidateBeanSearchSpec(context, metadata, ConditionalOnSingleCandidate.class);
            matching = this.getMatchingBeans(context, spec);
            if (matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnSingleCandidate " + spec + " found no beans");
            }
            if (!this.hasSingleAutowireCandidate(context.getBeanFactory(), matching)) {
                return ConditionOutcome.noMatch("@ConditionalOnSingleCandidate " + spec + " found no primary candidate amongst the" + " following " + matching);
            }
            matchMessage.append("@ConditionalOnSingleCandidate " + spec + " found " + "a primary candidate amongst the following " + matching);
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (!matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnMissingBean " + spec + " found the following " + matching);
            }
            matchMessage.append(matchMessage.length() == 0 ? "" : " ");
            matchMessage.append("@ConditionalOnMissingBean " + spec + " found no beans");
        }
        return ConditionOutcome.match(matchMessage.toString());
    }

    private List<String> getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        if (beanFactory == null) {
            return Collections.emptyList();
        }
        ArrayList<String> beanNames = new ArrayList<String>();
        boolean considerHierarchy = beans.getStrategy() == SearchStrategy.ALL;
        for (String type : beans.getTypes()) {
            beanNames.addAll(this.getBeanNamesForType((ListableBeanFactory)beanFactory, type, context.getClassLoader(), considerHierarchy));
        }
        for (String ignoredType : beans.getIgnoredTypes()) {
            beanNames.removeAll(this.getBeanNamesForType((ListableBeanFactory)beanFactory, ignoredType, context.getClassLoader(), considerHierarchy));
        }
        for (String annotation : beans.getAnnotations()) {
            beanNames.addAll(Arrays.asList(this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy)));
        }
        for (String beanName : beans.getNames()) {
            if (!this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            this.collectBeanNamesForType(result, beanFactory, ClassUtils.forName((String)type, (ClassLoader)classLoader), considerHierarchy);
            return result;
        }
        catch (ClassNotFoundException ex) {
            return Collections.emptySet();
        }
    }

    private void collectBeanNamesForType(Set<String> result, ListableBeanFactory beanFactory, Class<?> type, boolean considerHierarchy) {
        BeanFactory parent;
        result.addAll(BeanTypeRegistry.get(beanFactory).getNamesForType(type));
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForType(result, (ListableBeanFactory)parent, type, considerHierarchy);
        }
    }

    private String[] getBeanNamesForAnnotation(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        String[] result = NO_BEANS;
        try {
            Class typeClass = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            result = beanFactory.getBeanNamesForAnnotation(typeClass);
            if (considerHierarchy && beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
                String[] parentResult = this.getBeanNamesForAnnotation((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), type, classLoader, true);
                ArrayList<String> resultList = new ArrayList<String>();
                resultList.addAll(Arrays.asList(result));
                for (String beanName : parentResult) {
                    if (resultList.contains(beanName) || beanFactory.containsLocalBean(beanName)) continue;
                    resultList.add(beanName);
                }
                result = StringUtils.toStringArray(resultList);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            return NO_BEANS;
        }
    }

    private boolean hasSingleAutowireCandidate(ConfigurableListableBeanFactory beanFactory, List<String> beanNames) {
        return beanNames.size() == 1 || this.getPrimaryBeans(beanFactory, beanNames).size() == 1;
    }

    private List<String> getPrimaryBeans(ConfigurableListableBeanFactory beanFactory, List<String> beanNames) {
        ArrayList<String> primaryBeans = new ArrayList<String>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (beanDefinition == null || !beanDefinition.isPrimary()) continue;
            primaryBeans.add(beanName);
        }
        return primaryBeans;
    }

    private static class SingleCandidateBeanSearchSpec
    extends BeanSearchSpec {
        public SingleCandidateBeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            super(context, metadata, annotationType);
        }

        @Override
        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            super.collect(attributes, key, destination);
            destination.removeAll(Arrays.asList("", Object.class.getName()));
        }

        @Override
        protected void validate() {
            Assert.isTrue((this.getTypes().size() == 1 ? 1 : 0) != 0, (String)(this.annotationName() + " annotations must " + "specify only one type (got " + this.getTypes() + ")"));
        }
    }

    private static class BeanSearchSpec {
        private final Class<?> annotationType;
        private final List<String> names = new ArrayList<String>();
        private final List<String> types = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();
        private final List<String> ignoredTypes = new ArrayList<String>();
        private final SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            this.annotationType = annotationType;
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "type", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "annotation", this.annotations);
            this.collect((MultiValueMap<String, Object>)attributes, "ignored", this.ignoredTypes);
            this.collect((MultiValueMap<String, Object>)attributes, "ignoredType", this.ignoredTypes);
            if (this.types.isEmpty() && this.names.isEmpty()) {
                this.addDeducedBeanType(context, metadata, this.types);
            }
            this.strategy = (SearchStrategy)((Object)metadata.getAnnotationAttributes(annotationType.getName()).get("search"));
            this.validate();
        }

        protected void validate() {
            Assert.isTrue((boolean)this.hasAtLeastOne(this.types, this.names, this.annotations), (String)(this.annotationName() + " annotations must " + "specify at least one bean (type, name or annotation)"));
        }

        private boolean hasAtLeastOne(List<?> ... lists) {
            for (List<?> list : lists) {
                if (list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected String annotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List values = (List)attributes.get((Object)key);
            if (values != null) {
                for (Object value : values) {
                    if (value instanceof String[]) {
                        Collections.addAll(destination, (String[])value);
                        continue;
                    }
                    destination.add((String)value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                this.addDeducedBeanTypeForBeanMethod(context, metadata, beanTypes, (MethodMetadata)metadata);
            }
        }

        private void addDeducedBeanTypeForBeanMethod(ConditionContext context, AnnotatedTypeMetadata metadata, final List<String> beanTypes, final MethodMetadata methodMetadata) {
            block2: {
                try {
                    Class configClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), (ClassLoader)context.getClassLoader());
                    ReflectionUtils.doWithMethods((Class)configClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                            if (methodMetadata.getMethodName().equals(method.getName())) {
                                beanTypes.add(method.getReturnType().getName());
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug((Object)("Unable to deduce bean type for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName()), ex);
                }
            }
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public List<String> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.names.isEmpty()) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                if (!this.types.isEmpty()) {
                    string.append("; ");
                }
            }
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase());
            string.append(")");
            return string.toString();
        }
    }
}

