/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.SQLDialect;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.JooqExceptionTranslator;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataSourceConnectionProvider.class})
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    public TransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    public ExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)new JooqExceptionTranslator());
    }

    @org.springframework.context.annotation.Configuration
    @ConditionalOnMissingBean(value={DSLContext.class})
    @EnableConfigurationProperties(value={JooqProperties.class})
    public static class DslContextConfiguration {
        @Autowired
        private JooqProperties properties = new JooqProperties();
        @Autowired
        private ConnectionProvider connectionProvider;
        @Autowired(required=false)
        private TransactionProvider transactionProvider;
        @Autowired(required=false)
        private RecordMapperProvider recordMapperProvider;
        @Autowired(required=false)
        private Settings settings;
        @Autowired(required=false)
        private RecordListenerProvider[] recordListenerProviders;
        @Autowired
        private ExecuteListenerProvider[] executeListenerProviders;
        @Autowired(required=false)
        private VisitListenerProvider[] visitListenerProviders;

        @Bean
        public DefaultDSLContext dslContext(Configuration configuration) {
            return new DefaultDSLContext(configuration);
        }

        @Bean
        @ConditionalOnMissingBean(value={Configuration.class})
        public DefaultConfiguration jooqConfiguration() {
            DefaultConfiguration configuration = new DefaultConfiguration();
            if (!StringUtils.isEmpty((Object)this.properties.getSqlDialect())) {
                configuration.set(SQLDialect.valueOf((String)this.properties.getSqlDialect()));
            }
            configuration.set(this.connectionProvider);
            if (this.transactionProvider != null) {
                configuration.set(this.transactionProvider);
            }
            if (this.recordMapperProvider != null) {
                configuration.set(this.recordMapperProvider);
            }
            if (this.settings != null) {
                configuration.set(this.settings);
            }
            configuration.set(this.recordListenerProviders);
            configuration.set(this.executeListenerProviders);
            configuration.set(this.visitListenerProviders);
            return configuration;
        }
    }
}

