/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mail;

import java.util.Map;
import java.util.Properties;
import javax.activation.MimeType;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ConditionalOnClass(value={MimeMessage.class, MimeType.class})
@EnableConfigurationProperties(value={MailProperties.class})
public class MailSenderAutoConfiguration {

    @Configuration
    @ConditionalOnSingleCandidate(value=JavaMailSenderImpl.class)
    static class MailSenderValidator {
        @Autowired
        private MailProperties properties;
        @Autowired
        private JavaMailSenderImpl mailSender;

        MailSenderValidator() {
        }

        @PostConstruct
        public void validateConnection() {
            if (this.properties.isTestConnection()) {
                try {
                    this.mailSender.testConnection();
                }
                catch (MessagingException ex) {
                    throw new IllegalStateException("Mail server is not unavailable", ex);
                }
            }
        }
    }

    @ConditionalOnMissingBean(value={MailSender.class})
    @Conditional(value={MailSenderCondition.class})
    static class MailSenderConfiguration {
        @Autowired
        private MailProperties properties;
        @Autowired(required=false)
        private Session session;

        MailSenderConfiguration() {
        }

        @Bean
        public JavaMailSenderImpl mailSender() {
            JavaMailSenderImpl sender = new JavaMailSenderImpl();
            if (this.session != null) {
                sender.setSession(this.session);
            } else {
                this.applyProperties(sender);
            }
            return sender;
        }

        private void applyProperties(JavaMailSenderImpl sender) {
            sender.setHost(this.properties.getHost());
            if (this.properties.getPort() != null) {
                sender.setPort(this.properties.getPort().intValue());
            }
            sender.setUsername(this.properties.getUsername());
            sender.setPassword(this.properties.getPassword());
            sender.setDefaultEncoding(this.properties.getDefaultEncoding());
            if (!this.properties.getProperties().isEmpty()) {
                sender.setJavaMailProperties(this.asProperties(this.properties.getProperties()));
            }
        }

        private Properties asProperties(Map<String, String> source) {
            Properties properties = new Properties();
            properties.putAll(source);
            return properties;
        }

        static class MailSenderCondition
        extends AnyNestedCondition {
            public MailSenderCondition() {
                super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }

            @ConditionalOnProperty(prefix="spring.mail", name={"jndi-name"})
            static class JndiNameProperty {
                JndiNameProperty() {
                }
            }

            @ConditionalOnProperty(prefix="spring.mail", name={"host"})
            static class HostProperty {
                HostProperty() {
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Session.class})
    @ConditionalOnProperty(prefix="spring.mail", name={"jndi-name"})
    @ConditionalOnJndi
    static class JndiSessionConfiguration {
        @Autowired
        private MailProperties properties;

        JndiSessionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Session session() {
            String jndiName = this.properties.getJndiName();
            try {
                return (Session)new JndiLocatorDelegate().lookup(jndiName, Session.class);
            }
            catch (NamingException ex) {
                throw new IllegalStateException(String.format("Unable to find Session in JNDI location %s", jndiName), ex);
            }
        }
    }
}

