/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.info;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.info")
public class ProjectInfoProperties {
    private final Build build = new Build();
    private final Git git = new Git();

    public Build getBuild() {
        return this.build;
    }

    public Git getGit() {
        return this.git;
    }

    @Autowired
    void setDefaultGitLocation(@Value(value="${spring.git.properties:classpath:git.properties}") Resource defaultGitLocation) {
        this.getGit().setLocation(defaultGitLocation);
    }

    public static class Git {
        private Resource location;

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }
    }

    public static class Build {
        private Resource location = new ClassPathResource("META-INF/boot/build.properties");

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }
    }
}

