/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.SsoSecurityConfigurer;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.util.ClassUtils;

@Configuration
@Conditional(value={NeedsWebSecurityCondition.class})
public class OAuth2SsoDefaultConfiguration
extends WebSecurityConfigurerAdapter
implements Ordered {
    private final BeanFactory beanFactory;
    private final OAuth2SsoProperties sso;

    public OAuth2SsoDefaultConfiguration(BeanFactory beanFactory, OAuth2SsoProperties sso) {
        this.beanFactory = beanFactory;
        this.sso = sso;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().anyRequest()).authenticated();
        new SsoSecurityConfigurer(this.beanFactory).configure(http);
    }

    public int getOrder() {
        if (this.sso.getFilterOrder() != null) {
            return this.sso.getFilterOrder();
        }
        if (ClassUtils.isPresent((String)"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties", null)) {
            return 0x7FFFFFF3;
        }
        return 0x7FFFFFF8;
    }

    protected static class NeedsWebSecurityCondition
    extends SpringBootCondition {
        protected NeedsWebSecurityCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String[] enablers;
            for (String name : enablers = context.getBeanFactory().getBeanNamesForAnnotation(EnableOAuth2Sso.class)) {
                if (!context.getBeanFactory().isTypeMatch(name, WebSecurityConfigurerAdapter.class)) continue;
                return ConditionOutcome.noMatch("found @EnableOAuth2Sso on a WebSecurityConfigurerAdapter");
            }
            return ConditionOutcome.match("found no @EnableOAuth2Sso on a WebSecurityConfigurerAdapter");
        }
    }
}

