/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.JwtAccessTokenConverterConfigurer;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.SpringSocialTokenServices;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(value={AuthorizationServerEndpointsConfiguration.class})
public class ResourceServerTokenServicesConfiguration {
    private static final Log logger = LogFactory.getLog(ResourceServerTokenServicesConfiguration.class);

    private static class AcceptJsonRequestEnhancer
    implements RequestEnhancer {
        private AcceptJsonRequestEnhancer() {
        }

        public void enhance(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        }
    }

    private static class AcceptJsonRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private AcceptJsonRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            return execution.execute(request, body);
        }
    }

    private static class NotJwtTokenCondition
    extends SpringBootCondition {
        private JwtTokenCondition jwtTokenCondition = new JwtTokenCondition();

        private NotJwtTokenCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ConditionOutcome.inverse(this.jwtTokenCondition.getMatchOutcome(context, metadata));
        }
    }

    private static class NotTokenInfoCondition
    extends SpringBootCondition {
        private TokenInfoCondition tokenInfoCondition = new TokenInfoCondition();

        private NotTokenInfoCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ConditionOutcome.inverse(this.tokenInfoCondition.getMatchOutcome(context, metadata));
        }
    }

    private static class JwtTokenCondition
    extends SpringBootCondition {
        private JwtTokenCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "security.oauth2.resource.jwt.");
            String keyValue = resolver.getProperty("key-value");
            String keyUri = resolver.getProperty("key-uri");
            if (StringUtils.hasText((String)keyValue) || StringUtils.hasText((String)keyUri)) {
                return ConditionOutcome.match("public key is provided");
            }
            return ConditionOutcome.noMatch("public key is not provided");
        }
    }

    private static class TokenInfoCondition
    extends SpringBootCondition {
        private TokenInfoCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "security.oauth2.resource.");
            Boolean preferTokenInfo = (Boolean)resolver.getProperty("prefer-token-info", Boolean.class);
            if (preferTokenInfo == null) {
                preferTokenInfo = environment.resolvePlaceholders("${OAUTH2_RESOURCE_PREFERTOKENINFO:true}").equals("true");
            }
            String tokenInfoUri = resolver.getProperty("token-info-uri");
            String userInfoUri = resolver.getProperty("user-info-uri");
            if (!StringUtils.hasLength((String)userInfoUri)) {
                return ConditionOutcome.match("No user info provided");
            }
            if (StringUtils.hasLength((String)tokenInfoUri) && preferTokenInfo.booleanValue()) {
                return ConditionOutcome.match("Token info endpoint is preferred and user info provided");
            }
            return ConditionOutcome.noMatch("Token info endpoint is not provided");
        }
    }

    @Configuration
    @Conditional(value={JwtTokenCondition.class})
    protected static class JwtTokenServicesConfiguration {
        private RestTemplate keyUriRestTemplate = new RestTemplate();
        private final ResourceServerProperties resource;
        private final List<JwtAccessTokenConverterConfigurer> configurers;

        public JwtTokenServicesConfiguration(ResourceServerProperties resource, ObjectProvider<List<JwtAccessTokenConverterConfigurer>> configurersProvider) {
            this.resource = resource;
            this.configurers = (List)configurersProvider.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public DefaultTokenServices jwtTokenServices() {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(this.jwtTokenStore());
            return services;
        }

        @Bean
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtTokenEnhancer());
        }

        @Bean
        public JwtAccessTokenConverter jwtTokenEnhancer() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            String keyValue = this.resource.getJwt().getKeyValue();
            if (!StringUtils.hasText((String)keyValue)) {
                try {
                    keyValue = this.getKeyFromServer();
                }
                catch (ResourceAccessException ex) {
                    logger.warn((Object)"Failed to fetch token key (you may need to refresh when the auth server is back)");
                }
            }
            if (StringUtils.hasText((String)keyValue) && !keyValue.startsWith("-----BEGIN")) {
                converter.setSigningKey(keyValue);
            }
            if (keyValue != null) {
                converter.setVerifierKey(keyValue);
            }
            if (!CollectionUtils.isEmpty(this.configurers)) {
                AnnotationAwareOrderComparator.sort(this.configurers);
                for (JwtAccessTokenConverterConfigurer configurer : this.configurers) {
                    configurer.configure(converter);
                }
            }
            return converter;
        }

        private String getKeyFromServer() {
            HttpHeaders headers = new HttpHeaders();
            String username = this.resource.getClientId();
            String password = this.resource.getClientSecret();
            if (username != null && password != null) {
                byte[] token = Base64.encode((byte[])(username + ":" + password).getBytes());
                headers.add("Authorization", "Basic " + new String(token));
            }
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.resource.getJwt().getKeyUri();
            return (String)((Map)this.keyUriRestTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]).getBody()).get("value");
        }
    }

    @Configuration
    @Conditional(value={NotJwtTokenCondition.class})
    protected static class RemoteTokenServicesConfiguration {
        protected RemoteTokenServicesConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.social.connect.support.OAuth2ConnectionFactory"})
        @Conditional(value={NotTokenInfoCondition.class})
        protected static class UserInfoTokenServicesConfiguration {
            private final ResourceServerProperties sso;
            private final OAuth2RestOperations restTemplate;
            private final AuthoritiesExtractor authoritiesExtractor;

            public UserInfoTokenServicesConfiguration(ResourceServerProperties sso, @Qualifier(value="userInfoRestTemplate") ObjectProvider<OAuth2RestOperations> restTemplateProvider, ObjectProvider<AuthoritiesExtractor> authoritiesExtractorProvider) {
                this.sso = sso;
                this.restTemplate = (OAuth2RestOperations)restTemplateProvider.getIfAvailable();
                this.authoritiesExtractor = (AuthoritiesExtractor)authoritiesExtractorProvider.getIfAvailable();
            }

            @Bean
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setRestTemplate(this.restTemplate);
                services.setTokenType(this.sso.getTokenType());
                if (this.authoritiesExtractor != null) {
                    services.setAuthoritiesExtractor(this.authoritiesExtractor);
                }
                return services;
            }
        }

        @Configuration
        @ConditionalOnClass(value={OAuth2ConnectionFactory.class})
        @Conditional(value={NotTokenInfoCondition.class})
        protected static class SocialTokenServicesConfiguration {
            private final ResourceServerProperties sso;
            private final OAuth2ConnectionFactory<?> connectionFactory;
            private final OAuth2RestOperations restTemplate;
            private final AuthoritiesExtractor authoritiesExtractor;

            public SocialTokenServicesConfiguration(ResourceServerProperties sso, ObjectProvider<OAuth2ConnectionFactory<?>> connectionFactoryProvider, @Qualifier(value="userInfoRestTemplate") ObjectProvider<OAuth2RestOperations> restTemplateProvider, ObjectProvider<AuthoritiesExtractor> authoritiesExtractorProvider) {
                this.sso = sso;
                this.connectionFactory = (OAuth2ConnectionFactory)connectionFactoryProvider.getIfAvailable();
                this.restTemplate = (OAuth2RestOperations)restTemplateProvider.getIfAvailable();
                this.authoritiesExtractor = (AuthoritiesExtractor)authoritiesExtractorProvider.getIfAvailable();
            }

            @Bean
            @ConditionalOnBean(value={ConnectionFactoryLocator.class})
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public SpringSocialTokenServices socialTokenServices() {
                return new SpringSocialTokenServices(this.connectionFactory, this.sso.getClientId());
            }

            @Bean
            @ConditionalOnMissingBean(value={ConnectionFactoryLocator.class, ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setTokenType(this.sso.getTokenType());
                services.setRestTemplate(this.restTemplate);
                if (this.authoritiesExtractor != null) {
                    services.setAuthoritiesExtractor(this.authoritiesExtractor);
                }
                return services;
            }
        }

        @Configuration
        @Conditional(value={TokenInfoCondition.class})
        protected static class TokenInfoServicesConfiguration {
            private final ResourceServerProperties resource;

            protected TokenInfoServicesConfiguration(ResourceServerProperties resource) {
                this.resource = resource;
            }

            @Bean
            public RemoteTokenServices remoteTokenServices() {
                RemoteTokenServices services = new RemoteTokenServices();
                services.setCheckTokenEndpointUrl(this.resource.getTokenInfoUri());
                services.setClientId(this.resource.getClientId());
                services.setClientSecret(this.resource.getClientSecret());
                return services;
            }
        }
    }

    @Configuration
    protected static class UserInfoRestTemplateConfiguration {
        private static final AuthorizationCodeResourceDetails DEFAULT_RESOURCE_DETAILS = new AuthorizationCodeResourceDetails();
        private final List<UserInfoRestTemplateCustomizer> customizers;
        private final OAuth2ProtectedResourceDetails details;
        private final OAuth2ClientContext oauth2ClientContext;

        public UserInfoRestTemplateConfiguration(ObjectProvider<List<UserInfoRestTemplateCustomizer>> customizersProvider, ObjectProvider<OAuth2ProtectedResourceDetails> detailsProvider, ObjectProvider<OAuth2ClientContext> oauth2ClientContextProvider) {
            this.customizers = (List)customizersProvider.getIfAvailable();
            this.details = (OAuth2ProtectedResourceDetails)detailsProvider.getIfAvailable();
            this.oauth2ClientContext = (OAuth2ClientContext)oauth2ClientContextProvider.getIfAvailable();
        }

        @Bean(name={"userInfoRestTemplate"})
        public OAuth2RestTemplate userInfoRestTemplate() {
            OAuth2RestTemplate template = this.getTemplate((OAuth2ProtectedResourceDetails)(this.details == null ? DEFAULT_RESOURCE_DETAILS : this.details));
            template.getInterceptors().add(new AcceptJsonRequestInterceptor());
            AuthorizationCodeAccessTokenProvider accessTokenProvider = new AuthorizationCodeAccessTokenProvider();
            accessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new AcceptJsonRequestEnhancer());
            template.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
            if (!CollectionUtils.isEmpty(this.customizers)) {
                AnnotationAwareOrderComparator.sort(this.customizers);
                for (UserInfoRestTemplateCustomizer customizer : this.customizers) {
                    customizer.customize(template);
                }
            }
            return template;
        }

        private OAuth2RestTemplate getTemplate(OAuth2ProtectedResourceDetails details) {
            if (this.oauth2ClientContext == null) {
                return new OAuth2RestTemplate(details);
            }
            return new OAuth2RestTemplate(details, this.oauth2ClientContext);
        }

        static {
            DEFAULT_RESOURCE_DETAILS.setClientId("<N/A>");
            DEFAULT_RESOURCE_DETAILS.setUserAuthorizationUri("Not a URI because there is no client");
            DEFAULT_RESOURCE_DETAILS.setAccessTokenUri("Not a URI because there is no client");
        }
    }
}

