/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.HttpEncodingProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.web.OrderedCharacterEncodingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CharacterEncodingFilter;

@Configuration
@EnableConfigurationProperties(value={HttpEncodingProperties.class})
@ConditionalOnClass(value={CharacterEncodingFilter.class})
@ConditionalOnProperty(prefix="spring.http.encoding", value={"enabled"}, matchIfMissing=true)
public class HttpEncodingAutoConfiguration {
    private final HttpEncodingProperties httpEncodingProperties;

    public HttpEncodingAutoConfiguration(HttpEncodingProperties httpEncodingProperties) {
        this.httpEncodingProperties = httpEncodingProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={CharacterEncodingFilter.class})
    public CharacterEncodingFilter characterEncodingFilter() {
        OrderedCharacterEncodingFilter filter = new OrderedCharacterEncodingFilter();
        filter.setEncoding(this.httpEncodingProperties.getCharset().name());
        filter.setForceEncoding(this.httpEncodingProperties.isForce());
        return filter;
    }
}

