/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.boot.autoconfigure.web.DefaultErrorViewResolver;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.boot.autoconfigure.web.ErrorViewResolver;
import org.springframework.boot.autoconfigure.web.NonRecursivePropertyPlaceholderHelper;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.boot.web.servlet.ErrorPageRegistrar;
import org.springframework.boot.web.servlet.ErrorPageRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.Ordered;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.util.HtmlUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={ResourceProperties.class})
public class ErrorMvcAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final ServerProperties serverProperties;
    private final ResourceProperties resourceProperties;
    @Autowired(required=false)
    private List<ErrorViewResolver> errorViewResolvers;

    public ErrorMvcAutoConfiguration(ApplicationContext applicationContext, ServerProperties serverProperties, ResourceProperties resourceProperties) {
        this.applicationContext = applicationContext;
        this.serverProperties = serverProperties;
        this.resourceProperties = resourceProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes() {
        return new DefaultErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new BasicErrorController(errorAttributes, this.serverProperties.getError(), this.errorViewResolvers);
    }

    @Bean
    public ErrorPageCustomizer errorPageCustomizer() {
        return new ErrorPageCustomizer(this.serverProperties);
    }

    @Bean
    @ConditionalOnBean(value={DispatcherServlet.class})
    @ConditionalOnMissingBean
    public DefaultErrorViewResolver conventionErrorViewResolver() {
        return new DefaultErrorViewResolver(this.applicationContext, this.resourceProperties);
    }

    @Bean
    public static PreserveErrorControllerTargetClassPostProcessor preserveErrorControllerTargetClassPostProcessor() {
        return new PreserveErrorControllerTargetClassPostProcessor();
    }

    static class PreserveErrorControllerTargetClassPostProcessor
    implements BeanFactoryPostProcessor {
        PreserveErrorControllerTargetClassPostProcessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            String[] errorControllerBeans;
            for (String errorControllerBean : errorControllerBeans = beanFactory.getBeanNamesForType(ErrorController.class, false, false)) {
                try {
                    beanFactory.getBeanDefinition(errorControllerBean).setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class ErrorPageCustomizer
    implements ErrorPageRegistrar,
    Ordered {
        private final ServerProperties properties;

        protected ErrorPageCustomizer(ServerProperties properties) {
            this.properties = properties;
        }

        public void registerErrorPages(ErrorPageRegistry errorPageRegistry) {
            ErrorPage errorPage = new ErrorPage(this.properties.getServletPrefix() + this.properties.getError().getPath());
            errorPageRegistry.addErrorPages(new ErrorPage[]{errorPage});
        }

        public int getOrder() {
            return 0;
        }
    }

    private static class ExpressionResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Map<String, Expression> expressions;
        private final EvaluationContext context;

        ExpressionResolver(Map<String, Expression> expressions, Map<String, ?> map) {
            this.expressions = expressions;
            this.context = this.getContext(map);
        }

        private EvaluationContext getContext(Map<String, ?> map) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            context.setRootObject(map);
            return context;
        }

        public String resolvePlaceholder(String placeholderName) {
            Expression expression = this.expressions.get(placeholderName);
            return this.escape(expression == null ? null : expression.getValue(this.context));
        }

        private String escape(Object value) {
            return HtmlUtils.htmlEscape((String)(value == null ? null : value.toString()));
        }
    }

    private static class ExpressionCollector
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final SpelExpressionParser parser = new SpelExpressionParser();
        private final Map<String, Expression> expressions = new HashMap<String, Expression>();

        private ExpressionCollector() {
        }

        public String resolvePlaceholder(String name) {
            this.expressions.put(name, this.parser.parseExpression(name));
            return null;
        }

        public Map<String, Expression> getExpressions() {
            return Collections.unmodifiableMap(this.expressions);
        }
    }

    private static class SpelView
    implements View {
        private final NonRecursivePropertyPlaceholderHelper helper = new NonRecursivePropertyPlaceholderHelper("${", "}");
        private final String template;
        private final Map<String, Expression> expressions;

        SpelView(String template) {
            this.template = template;
            ExpressionCollector expressionCollector = new ExpressionCollector();
            this.helper.replacePlaceholders(this.template, expressionCollector);
            this.expressions = expressionCollector.getExpressions();
        }

        public String getContentType() {
            return "text/html";
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (response.getContentType() == null) {
                response.setContentType(this.getContentType());
            }
            HashMap map = new HashMap(model);
            map.put("path", request.getContextPath());
            ExpressionResolver resolver = new ExpressionResolver(this.expressions, map);
            String result = this.helper.replacePlaceholders(this.template, resolver);
            response.getWriter().append(result);
        }
    }

    private static class ErrorTemplateMissingCondition
    extends SpringBootCondition {
        private ErrorTemplateMissingCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            List availabilityProviders = SpringFactoriesLoader.loadFactories(TemplateAvailabilityProvider.class, (ClassLoader)context.getClassLoader());
            for (TemplateAvailabilityProvider availabilityProvider : availabilityProviders) {
                if (!availabilityProvider.isTemplateAvailable("error", context.getEnvironment(), context.getClassLoader(), context.getResourceLoader())) continue;
                return ConditionOutcome.noMatch("Template from " + availabilityProvider + " found for error view");
            }
            return ConditionOutcome.match("No error template view detected");
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="server.error.whitelabel", name={"enabled"}, matchIfMissing=true)
    @Conditional(value={ErrorTemplateMissingCondition.class})
    protected static class WhitelabelErrorViewConfiguration {
        private final SpelView defaultErrorView = new SpelView("<html><body><h1>Whitelabel Error Page</h1><p>This application has no explicit mapping for /error, so you are seeing this as a fallback.</p><div id='created'>${timestamp}</div><div>There was an unexpected error (type=${error}, status=${status}).</div><div>${message}</div></body></html>");

        protected WhitelabelErrorViewConfiguration() {
        }

        @Bean(name={"error"})
        @ConditionalOnMissingBean(name={"error"})
        public View defaultErrorView() {
            return this.defaultErrorView;
        }

        @Bean
        @ConditionalOnMissingBean(value={BeanNameViewResolver.class})
        public BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }
    }
}

