/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQMode;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class HornetQConnectionFactoryFactory {
    static final String EMBEDDED_JMS_CLASS = "org.hornetq.jms.server.embedded.EmbeddedJMS";
    private final HornetQProperties properties;
    private final ListableBeanFactory beanFactory;

    HornetQConnectionFactoryFactory(ListableBeanFactory beanFactory, HornetQProperties properties) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.beanFactory = beanFactory;
        this.properties = properties;
    }

    public <T extends HornetQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        try {
            this.startEmbeddedJms();
            return this.doCreateConnectionFactory(factoryClass);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create HornetQConnectionFactory", ex);
        }
    }

    private void startEmbeddedJms() {
        if (ClassUtils.isPresent((String)EMBEDDED_JMS_CLASS, null)) {
            try {
                this.beanFactory.getBeansOfType(Class.forName(EMBEDDED_JMS_CLASS));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <T extends HornetQConnectionFactory> T doCreateConnectionFactory(Class<T> factoryClass) throws Exception {
        HornetQMode mode = this.properties.getMode();
        if (mode == null) {
            mode = this.deduceMode();
        }
        if (mode == HornetQMode.EMBEDDED) {
            return this.createEmbeddedConnectionFactory(factoryClass);
        }
        return this.createNativeConnectionFactory(factoryClass);
    }

    private HornetQMode deduceMode() {
        if (this.properties.getEmbedded().isEnabled() && ClassUtils.isPresent((String)EMBEDDED_JMS_CLASS, null)) {
            return HornetQMode.EMBEDDED;
        }
        return HornetQMode.NATIVE;
    }

    private <T extends HornetQConnectionFactory> T createEmbeddedConnectionFactory(Class<T> factoryClass) throws Exception {
        try {
            TransportConfiguration transportConfiguration = new TransportConfiguration(InVMConnectorFactory.class.getName(), this.properties.getEmbedded().generateTransportParameters());
            ServerLocator serviceLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            Constructor<T> constructor = factoryClass.getDeclaredConstructor(HornetQProperties.class, ServerLocator.class);
            return (T)((HornetQConnectionFactory)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.properties, serviceLocator}));
        }
        catch (NoClassDefFoundError ex) {
            throw new IllegalStateException("Unable to create InVM HornetQ connection, ensure that hornet-jms-server.jar is in the classpath", ex);
        }
    }

    private <T extends HornetQConnectionFactory> T createNativeConnectionFactory(Class<T> factoryClass) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", this.properties.getHost());
        params.put("port", this.properties.getPort());
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        Constructor<T> constructor = factoryClass.getDeclaredConstructor(HornetQProperties.class, Boolean.TYPE, TransportConfiguration[].class);
        return (T)((HornetQConnectionFactory)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.properties, false, new TransportConfiguration[]{transportConfiguration}}));
    }
}

