/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.jms.client.HornetQXAConnectionFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.util.StringUtils;

class SpringBootHornetQXAConnectionFactory
extends HornetQXAConnectionFactory {
    private final HornetQProperties properties;

    SpringBootHornetQXAConnectionFactory(HornetQProperties properties, ServerLocator serverLocator) {
        super(serverLocator);
        this.properties = properties;
    }

    SpringBootHornetQXAConnectionFactory(HornetQProperties properties, boolean ha, TransportConfiguration ... initialConnectors) {
        super(ha, initialConnectors);
        this.properties = properties;
    }

    public Connection createConnection() throws JMSException {
        String user = this.properties.getUser();
        if (StringUtils.hasText((String)user)) {
            return this.createConnection(user, this.properties.getPassword());
        }
        return super.createConnection();
    }
}

