/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.net.UnknownHostException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.DefaultLettucePool;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, RedisClient.class, RedisClusterClient.class})
class LettuceConnectionConfiguration
extends RedisConnectionConfiguration {
    private final RedisProperties properties;

    LettuceConnectionConfiguration(RedisProperties properties, ObjectProvider<RedisSentinelConfiguration> sentinelConfigurationProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigurationProvider) {
        super(properties, sentinelConfigurationProvider, clusterConfigurationProvider);
        this.properties = properties;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ClientResources.class})
    public DefaultClientResources lettuceClientResources() {
        return DefaultClientResources.create();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public LettuceConnectionFactory redisConnectionFactory(ClientResources clientResources) throws UnknownHostException {
        return this.applyProperties(this.createLettuceConnectionFactory(clientResources));
    }

    private LettuceConnectionFactory applyProperties(LettuceConnectionFactory factory) {
        RedisProperties.Lettuce lettuce;
        this.configureConnection(factory);
        if (this.properties.isSsl()) {
            factory.setUseSsl(true);
        }
        if (this.properties.getLettuce() != null && (lettuce = this.properties.getLettuce()).getShutdownTimeout() >= 0) {
            factory.setShutdownTimeout((long)this.properties.getLettuce().getShutdownTimeout());
        }
        return factory;
    }

    private void configureConnection(LettuceConnectionFactory factory) {
        if (StringUtils.hasText((String)this.properties.getUrl())) {
            this.configureConnectionFromUrl(factory);
        } else {
            factory.setHostName(this.properties.getHost());
            factory.setPort(this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
            factory.setDatabase(this.properties.getDatabase());
            if (this.properties.getTimeout() > 0) {
                factory.setTimeout((long)this.properties.getTimeout());
            }
        }
    }

    private void configureConnectionFromUrl(LettuceConnectionFactory factory) {
        RedisConnectionConfiguration.ConnectionInfo connectionInfo = this.parseUrl(this.properties.getUrl());
        factory.setUseSsl(connectionInfo.isUseSsl());
        factory.setHostName(connectionInfo.getHostName());
        factory.setPort(connectionInfo.getPort());
        if (connectionInfo.getPassword() != null) {
            factory.setPassword(connectionInfo.getPassword());
        }
    }

    private DefaultLettucePool applyProperties(DefaultLettucePool pool) {
        if (StringUtils.hasText((String)this.properties.getUrl())) {
            this.configureConnectionFromUrl(pool);
        } else {
            pool.setHostName(this.properties.getHost());
            pool.setPort(this.properties.getPort());
            if (this.properties.getPassword() != null) {
                pool.setPassword(this.properties.getPassword());
            }
            pool.setDatabase(this.properties.getDatabase());
        }
        if (this.properties.getTimeout() > 0) {
            pool.setTimeout((long)this.properties.getTimeout());
        }
        pool.afterPropertiesSet();
        return pool;
    }

    private void configureConnectionFromUrl(DefaultLettucePool lettucePool) {
        RedisConnectionConfiguration.ConnectionInfo connectionInfo = this.parseUrl(this.properties.getUrl());
        lettucePool.setHostName(connectionInfo.getHostName());
        lettucePool.setPort(connectionInfo.getPort());
        if (connectionInfo.getPassword() != null) {
            lettucePool.setPassword(connectionInfo.getPassword());
        }
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(ClientResources clientResources) {
        if (this.getSentinelConfig() != null) {
            if (this.properties.getLettuce() != null && this.properties.getLettuce().getPool() != null) {
                DefaultLettucePool lettucePool = new DefaultLettucePool(this.getSentinelConfig());
                return new LettuceConnectionFactory((LettucePool)this.applyProperties(this.applyClientResources(lettucePool, clientResources)));
            }
            return this.applyClientResources(new LettuceConnectionFactory(this.getSentinelConfig()), clientResources);
        }
        if (this.getClusterConfiguration() != null) {
            return this.applyClientResources(new LettuceConnectionFactory(this.getClusterConfiguration()), clientResources);
        }
        if (this.properties.getLettuce() != null && this.properties.getLettuce().getPool() != null) {
            GenericObjectPoolConfig config = this.lettucePoolConfig(this.properties.getLettuce().getPool());
            DefaultLettucePool lettucePool = new DefaultLettucePool(this.properties.getHost(), this.properties.getPort(), config);
            return new LettuceConnectionFactory((LettucePool)this.applyProperties(this.applyClientResources(lettucePool, clientResources)));
        }
        return this.applyClientResources(new LettuceConnectionFactory(), clientResources);
    }

    private DefaultLettucePool applyClientResources(DefaultLettucePool lettucePool, ClientResources clientResources) {
        lettucePool.setClientResources(clientResources);
        return lettucePool;
    }

    private LettuceConnectionFactory applyClientResources(LettuceConnectionFactory factory, ClientResources clientResources) {
        factory.setClientResources(clientResources);
        return factory;
    }

    private GenericObjectPoolConfig lettucePoolConfig(RedisProperties.Pool props) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(props.getMaxActive());
        config.setMaxIdle(props.getMaxIdle());
        config.setMinIdle(props.getMinIdle());
        config.setMaxWaitMillis((long)props.getMaxWait());
        return config;
    }
}

