/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import java.util.stream.Collectors;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RetryTemplateFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class})
@Import(value={RabbitAnnotationDrivenConfiguration.class})
public class RabbitAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RabbitMessagingTemplate.class})
    @ConditionalOnMissingBean(value={RabbitMessagingTemplate.class})
    @Import(value={RabbitTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=RabbitTemplate.class)
        public RabbitMessagingTemplate rabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
            return new RabbitMessagingTemplate(rabbitTemplate);
        }
    }

    @Configuration
    @Import(value={RabbitConnectionFactoryCreator.class})
    protected static class RabbitTemplateConfiguration {
        protected RabbitTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnMissingBean
        public RabbitTemplate rabbitTemplate(RabbitProperties properties, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            PropertyMapper map = PropertyMapper.get();
            RabbitTemplate template = new RabbitTemplate(connectionFactory);
            messageConverter.ifUnique(arg_0 -> ((RabbitTemplate)template).setMessageConverter(arg_0));
            template.setMandatory(this.determineMandatoryFlag(properties));
            RabbitProperties.Template templateProperties = properties.getTemplate();
            if (templateProperties.getRetry().isEnabled()) {
                template.setRetryTemplate(new RetryTemplateFactory(retryTemplateCustomizers.orderedStream().collect(Collectors.toList())).createRetryTemplate(templateProperties.getRetry(), RabbitRetryTemplateCustomizer.Target.SENDER));
            }
            map.from(templateProperties::getReceiveTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReceiveTimeout(arg_0));
            map.from(templateProperties::getReplyTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReplyTimeout(arg_0));
            map.from(templateProperties::getExchange).to(arg_0 -> ((RabbitTemplate)template).setExchange(arg_0));
            map.from(templateProperties::getRoutingKey).to(arg_0 -> ((RabbitTemplate)template).setRoutingKey(arg_0));
            map.from(templateProperties::getDefaultReceiveQueue).whenNonNull().to(arg_0 -> ((RabbitTemplate)template).setDefaultReceiveQueue(arg_0));
            return template;
        }

        private boolean determineMandatoryFlag(RabbitProperties properties) {
            Boolean mandatory = properties.getTemplate().getMandatory();
            return mandatory != null ? mandatory.booleanValue() : properties.isPublisherReturns();
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnProperty(prefix="spring.rabbitmq", name={"dynamic"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public AmqpAdmin amqpAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            return new RabbitAdmin(connectionFactory);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={org.springframework.amqp.rabbit.connection.ConnectionFactory.class})
    protected static class RabbitConnectionFactoryCreator {
        protected RabbitConnectionFactoryCreator() {
        }

        @Bean
        public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties properties, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            CachingConnectionFactory factory = new CachingConnectionFactory((ConnectionFactory)this.getRabbitConnectionFactoryBean(properties).getObject());
            map.from(properties::determineAddresses).to(arg_0 -> ((CachingConnectionFactory)factory).setAddresses(arg_0));
            map.from(properties::isPublisherConfirms).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherConfirms(arg_0));
            map.from(properties::isPublisherReturns).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherReturns(arg_0));
            RabbitProperties.Cache.Channel channel = properties.getCache().getChannel();
            map.from(channel::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCacheSize(arg_0));
            map.from(channel::getCheckoutTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCheckoutTimeout(arg_0));
            RabbitProperties.Cache.Connection connection = properties.getCache().getConnection();
            map.from(connection::getMode).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setCacheMode(arg_0));
            map.from(connection::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionCacheSize(arg_0));
            map.from(() -> connectionNameStrategy.getIfUnique()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionNameStrategy(arg_0));
            return factory;
        }

        private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
            map.from(properties::determineHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setHost(arg_0));
            map.from(properties::determinePort).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPort(arg_0));
            map.from(properties::determineUsername).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setUsername(arg_0));
            map.from(properties::determinePassword).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPassword(arg_0));
            map.from(properties::determineVirtualHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setVirtualHost(arg_0));
            map.from(properties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedHeartbeat(arg_0));
            RabbitProperties.Ssl ssl = properties.getSsl();
            if (ssl.isEnabled()) {
                factory.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setSslAlgorithm(arg_0));
                map.from(ssl::getKeyStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreType(arg_0));
                map.from(ssl::getKeyStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStore(arg_0));
                map.from(ssl::getKeyStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStorePassphrase(arg_0));
                map.from(ssl::getTrustStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreType(arg_0));
                map.from(ssl::getTrustStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStore(arg_0));
                map.from(ssl::getTrustStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStorePassphrase(arg_0));
                map.from(ssl::isValidateServerCertificate).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::getVerifyHostname).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setEnableHostnameVerification(arg_0));
            }
            map.from(properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setConnectionTimeout(arg_0));
            factory.afterPropertiesSet();
            return factory;
        }
    }
}

