/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.ExecutorProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordUnmapperProvider;
import org.jooq.TransactionListenerProvider;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.JooqExceptionTranslator;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@org.springframework.context.annotation.Configuration
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, TransactionAutoConfiguration.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    public SpringTransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    @Order(value=0)
    public DefaultExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)new JooqExceptionTranslator());
    }

    @org.springframework.context.annotation.Configuration
    @ConditionalOnMissingBean(value={DSLContext.class})
    @EnableConfigurationProperties(value={JooqProperties.class})
    public static class DslContextConfiguration {
        @Bean
        public DefaultDSLContext dslContext(Configuration configuration) {
            return new DefaultDSLContext(configuration);
        }

        @Bean
        @ConditionalOnMissingBean(value={Configuration.class})
        public DefaultConfiguration jooqConfiguration(JooqProperties properties, ConnectionProvider connectionProvider, DataSource dataSource, ObjectProvider<TransactionProvider> transactionProvider, ObjectProvider<RecordMapperProvider> recordMapperProvider, ObjectProvider<RecordUnmapperProvider> recordUnmapperProvider, ObjectProvider<Settings> settings, ObjectProvider<RecordListenerProvider> recordListenerProviders, ObjectProvider<ExecuteListenerProvider> executeListenerProviders, ObjectProvider<VisitListenerProvider> visitListenerProviders, ObjectProvider<TransactionListenerProvider> transactionListenerProviders, ObjectProvider<ExecutorProvider> executorProvider) {
            DefaultConfiguration configuration = new DefaultConfiguration();
            configuration.set(properties.determineSqlDialect(dataSource));
            configuration.set(connectionProvider);
            transactionProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            recordMapperProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            recordUnmapperProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            settings.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            executorProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            configuration.set((RecordListenerProvider[])recordListenerProviders.orderedStream().toArray(RecordListenerProvider[]::new));
            configuration.set((ExecuteListenerProvider[])executeListenerProviders.orderedStream().toArray(ExecuteListenerProvider[]::new));
            configuration.set((VisitListenerProvider[])visitListenerProviders.orderedStream().toArray(VisitListenerProvider[]::new));
            configuration.setTransactionListenerProvider((TransactionListenerProvider[])transactionListenerProviders.orderedStream().toArray(TransactionListenerProvider[]::new));
            return configuration;
        }
    }
}

