/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

public class InspectedContent
implements Content {
    static final int MEMORY_LIMIT = 4099;
    private final int size;
    private final Object content;

    InspectedContent(int size, Object content) {
        this.size = size;
        this.content = content;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.content instanceof byte[]) {
            FileCopyUtils.copy((byte[])((byte[])this.content), (OutputStream)outputStream);
        } else if (this.content instanceof File) {
            FileCopyUtils.copy((InputStream)new FileInputStream((File)this.content), (OutputStream)outputStream);
        } else {
            throw new IllegalStateException("Unknown content type");
        }
    }

    public static InspectedContent of(InputStream inputStream, Inspector ... inspectors) throws IOException {
        Assert.notNull((Object)inputStream, (String)"InputStream must not be null");
        return InspectedContent.of((OutputStream outputStream) -> FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream), inspectors);
    }

    public static InspectedContent of(Content content, Inspector ... inspectors) throws IOException {
        Assert.notNull((Object)content, (String)"Content must not be null");
        return InspectedContent.of(content::writeTo, inspectors);
    }

    public static InspectedContent of(IOConsumer<OutputStream> writer, Inspector ... inspectors) throws IOException {
        Assert.notNull(writer, (String)"Writer must not be null");
        try (InspectingOutputStream outputStream = new InspectingOutputStream(inspectors);){
            writer.accept(outputStream);
        }
        return new InspectedContent(outputStream.getSize(), outputStream.getContent());
    }

    private static final class InspectingOutputStream
    extends OutputStream {
        private final Inspector[] inspectors;
        private int size;
        private OutputStream delegate;
        private File tempFile;
        private final byte[] singleByteBuffer = new byte[0];

        private InspectingOutputStream(Inspector[] inspectors) {
            this.inspectors = inspectors;
            this.delegate = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByteBuffer[0] = (byte)(b & 0xFF);
            this.write(this.singleByteBuffer);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int size = len - off;
            if (this.tempFile == null && this.size + size > 4099) {
                this.convertToTempFile();
            }
            this.delegate.write(b, off, len);
            for (Inspector inspector : this.inspectors) {
                inspector.update(b, off, len);
            }
            this.size += size;
        }

        private void convertToTempFile() throws IOException {
            this.tempFile = File.createTempFile("buildpack", ".tmp");
            byte[] bytes = ((ByteArrayOutputStream)this.delegate).toByteArray();
            this.delegate = new FileOutputStream(this.tempFile);
            StreamUtils.copy((byte[])bytes, (OutputStream)this.delegate);
        }

        private Object getContent() {
            return this.tempFile != null ? this.tempFile : (Object)((ByteArrayOutputStream)this.delegate).toByteArray();
        }

        private int getSize() {
            return this.size;
        }
    }

    public static interface Inspector {
        public void update(byte[] var1, int var2, int var3) throws IOException;
    }
}

