/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Image
extends MappedObject {
    private final List<String> digests = this.childrenAt("/RepoDigests", JsonNode::asText);
    private final ImageConfig config = new ImageConfig(this.getNode().at("/Config"));
    private final List<LayerId> layers = this.extractLayers(this.valueAt("/RootFS/Layers", String[].class));
    private final String os = this.valueAt("/Os", String.class);
    private final String architecture = this.valueAt("/Architecture", String.class);
    private final String variant = this.valueAt("/Variant", String.class);
    private final String created = this.valueAt("/Created", String.class);
    private final Descriptor descriptor;

    Image(JsonNode node) {
        super(node, MethodHandles.lookup());
        JsonNode descriptorNode = this.getNode().path("Descriptor");
        this.descriptor = descriptorNode.isMissingNode() || descriptorNode.isNull() ? null : new Descriptor(descriptorNode);
    }

    private List<LayerId> extractLayers(String[] layers) {
        if (layers == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(layers).map(LayerId::of).toList();
    }

    public List<String> getDigests() {
        return this.digests;
    }

    public ImageConfig getConfig() {
        return this.config;
    }

    public List<LayerId> getLayers() {
        return this.layers;
    }

    public String getOs() {
        return StringUtils.hasText((String)this.os) ? this.os : "linux";
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getCreated() {
        return this.created;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getPrimaryDigest() {
        if (this.descriptor != null && StringUtils.hasText((String)this.descriptor.getDigest())) {
            return this.descriptor.getDigest();
        }
        if (!CollectionUtils.isEmpty(this.digests)) {
            try {
                return ImageReference.of(this.digests.get(0)).getDigest();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Image of(InputStream content) throws IOException {
        return Image.of(content, Image::new);
    }

    public final class Descriptor
    extends MappedObject {
        private final String digest;

        Descriptor(JsonNode node) {
            super(node, MethodHandles.lookup());
            this.digest = Objects.requireNonNull(this.valueAt("/digest", String.class));
        }

        public String getDigest() {
            return this.digest;
        }
    }
}

