/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class BuildpackMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.buildpackage.metadata";
    private final String id = this.extractId();
    private final @Nullable String version = this.valueAt("/version", String.class);
    private final @Nullable String homepage = this.valueAt("/homepage", String.class);

    private BuildpackMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private String extractId() {
        String result = this.valueAt("/id", String.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    String getId() {
        return this.id;
    }

    @Nullable String getVersion() {
        return this.version;
    }

    @Nullable String getHomepage() {
        return this.homepage;
    }

    static BuildpackMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"'image' must not be null");
        return BuildpackMetadata.fromImageConfig(image.getConfig());
    }

    static BuildpackMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"'imageConfig' must not be null");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.state((json != null ? 1 : 0) != 0, () -> "No 'io.buildpacks.buildpackage.metadata' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuildpackMetadata.fromJson(json);
    }

    static BuildpackMetadata fromJson(String json) throws IOException {
        return BuildpackMetadata.fromJson(SharedObjectMapper.get().readTree(json));
    }

    static BuildpackMetadata fromJson(JsonNode node) {
        return new BuildpackMetadata(node);
    }
}

