/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ObjectNode;

public class JsonStream {
    private final JsonMapper jsonMapper;

    public JsonStream(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public void get(InputStream content, Consumer<ObjectNode> consumer) throws IOException {
        this.get(content, ObjectNode.class, consumer);
    }

    public <T> void get(InputStream content, Class<T> type, Consumer<T> consumer) throws IOException {
        try (JsonParser parser = this.jsonMapper.createParser(content);){
            while (!parser.isClosed()) {
                T node;
                JsonToken token = parser.nextToken();
                if (token == null || token == JsonToken.END_OBJECT || (node = this.read(parser, type)) == null) continue;
                consumer.accept(node);
            }
        }
    }

    private <T> @Nullable T read(JsonParser parser, Class<T> type) {
        if (ObjectNode.class.isAssignableFrom(type)) {
            ObjectNode node = (ObjectNode)this.jsonMapper.readTree(parser);
            if (node == null || node.isMissingNode() || node.isEmpty()) {
                return null;
            }
            return (T)node;
        }
        return (T)this.jsonMapper.readValue(parser, type);
    }
}

