/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.configurationprocessor.metadata.ItemHint;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

public class ConfigurationMetadata {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private final List<ItemMetadata> items;
    private final List<ItemHint> hints;

    public ConfigurationMetadata() {
        this.items = new ArrayList<ItemMetadata>();
        this.hints = new ArrayList<ItemHint>();
    }

    public ConfigurationMetadata(ConfigurationMetadata metadata) {
        this.items = new ArrayList<ItemMetadata>(metadata.getItems());
        this.hints = new ArrayList<ItemHint>(metadata.getHints());
    }

    public void add(ItemMetadata itemMetadata) {
        this.items.add(itemMetadata);
        Collections.sort(this.items);
    }

    public void add(ItemHint itemHint) {
        this.hints.add(itemHint);
        Collections.sort(this.hints);
    }

    public void addAll(ConfigurationMetadata metadata) {
        this.items.addAll(metadata.getItems());
        Collections.sort(this.items);
        this.hints.addAll(metadata.getHints());
        Collections.sort(this.hints);
    }

    public List<ItemMetadata> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public List<ItemHint> getHints() {
        return Collections.unmodifiableList(this.hints);
    }

    public static String nestedPrefix(String prefix, String name) {
        String nestedPrefix = prefix == null ? "" : prefix;
        String dashedName = ConfigurationMetadata.toDashedCase(name);
        nestedPrefix = nestedPrefix + ("".equals(nestedPrefix) ? dashedName : "." + dashedName);
        return nestedPrefix;
    }

    static String toDashedCase(String name) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(name);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, ConfigurationMetadata.getDashed(matcher));
        }
        matcher.appendTail(result);
        return result.toString().toLowerCase();
    }

    private static String getDashed(Matcher matcher) {
        String first = matcher.group(1);
        String second = matcher.group(2);
        if (first.equals("_")) {
            return first + second;
        }
        return first + "-" + second;
    }
}

