/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools;

import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.RemoteUrlPropertyExtractor;
import org.springframework.boot.devtools.remote.client.RemoteClientConfiguration;
import org.springframework.boot.devtools.restart.RestartInitializer;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class RemoteSpringApplication {
    private void run(String[] args) {
        Restarter.initialize(args, RestartInitializer.NONE);
        SpringApplication application = new SpringApplication(new Object[]{RemoteClientConfiguration.class});
        application.setWebEnvironment(false);
        application.setBanner(this.getBanner());
        application.addListeners(new ApplicationListener[]{new RemoteUrlPropertyExtractor()});
        application.run(args);
        this.waitIndefinitely();
    }

    private Banner getBanner() {
        ClassPathResource banner = new ClassPathResource("remote-banner.txt", RemoteSpringApplication.class);
        return new ResourceBanner((Resource)banner);
    }

    private void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        new RemoteSpringApplication().run(args);
    }
}

