/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.devtools.restart.ChangeableUrls;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.FailureHandler;
import org.springframework.boot.devtools.restart.MainMethod;
import org.springframework.boot.devtools.restart.RestartInitializer;
import org.springframework.boot.devtools.restart.RestartLauncher;
import org.springframework.boot.devtools.restart.SilentExitExceptionHandler;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.boot.devtools.restart.classloader.RestartClassLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cglib.core.ClassNameReader;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Restarter {
    private static final String[] NO_ARGS = new String[0];
    private static Restarter instance;
    private Log logger = new DeferredLog();
    private final boolean forceReferenceCleanup;
    private boolean enabled = true;
    private URL[] initialUrls;
    private final String mainClassName;
    private final ClassLoader applicationClassLoader;
    private final String[] args;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Set<URL> urls = new LinkedHashSet<URL>();
    private final ClassLoaderFiles classLoaderFiles = new ClassLoaderFiles();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final BlockingDeque<LeakSafeThread> leakSafeThreads = new LinkedBlockingDeque<LeakSafeThread>();
    private boolean finished = false;
    private Lock stopLock = new ReentrantLock();

    protected Restarter(Thread thread, String[] args, boolean forceReferenceCleanup, RestartInitializer initializer) {
        Assert.notNull((Object)thread, (String)"Thread must not be null");
        Assert.notNull((Object)args, (String)"Args must not be null");
        Assert.notNull((Object)initializer, (String)"Initializer must not be null");
        this.logger.debug((Object)("Creating new Restarter for thread " + thread));
        SilentExitExceptionHandler.setup(thread);
        this.forceReferenceCleanup = forceReferenceCleanup;
        this.initialUrls = initializer.getInitialUrls(thread);
        this.mainClassName = this.getMainClassName(thread);
        this.applicationClassLoader = thread.getContextClassLoader();
        this.args = args;
        this.exceptionHandler = thread.getUncaughtExceptionHandler();
        this.leakSafeThreads.add(new LeakSafeThread());
    }

    private String getMainClassName(Thread thread) {
        try {
            return new MainMethod(thread).getDeclaringClassName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void initialize(boolean restartOnInitialize) {
        this.preInitializeLeakyClasses();
        if (this.initialUrls != null) {
            this.urls.addAll(Arrays.asList(this.initialUrls));
            if (restartOnInitialize) {
                this.logger.debug((Object)"Immediately restarting application");
                this.immediateRestart();
            }
        }
    }

    private void immediateRestart() {
        try {
            this.getLeakSafeThread().callAndWait(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Restarter.this.start(FailureHandler.NONE);
                    Restarter.this.cleanupCaches();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Unable to initialize restarter", (Throwable)ex);
        }
        SilentExitExceptionHandler.exitCurrentThread();
    }

    private void preInitializeLeakyClasses() {
        try {
            Class<ClassNameReader> readerClass = ClassNameReader.class;
            Field field = readerClass.getDeclaredField("EARLY_EXIT");
            field.setAccessible(true);
            ((Throwable)field.get(null)).fillInStackTrace();
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Unable to pre-initialize classes", (Throwable)ex);
        }
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addUrls(Collection<URL> urls) {
        Assert.notNull(urls, (String)"Urls must not be null");
        this.urls.addAll(ChangeableUrls.fromUrls(urls).toList());
    }

    public void addClassLoaderFiles(ClassLoaderFiles classLoaderFiles) {
        Assert.notNull((Object)classLoaderFiles, (String)"ClassLoaderFiles must not be null");
        this.classLoaderFiles.addAll(classLoaderFiles);
    }

    public ThreadFactory getThreadFactory() {
        return new LeakSafeThreadFactory();
    }

    public void restart() {
        this.restart(FailureHandler.NONE);
    }

    public void restart(final FailureHandler failureHandler) {
        if (!this.enabled) {
            this.logger.debug((Object)"Application restart is disabled");
            return;
        }
        this.logger.debug((Object)"Restarting application");
        this.getLeakSafeThread().call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Restarter.this.stop();
                Restarter.this.start(failureHandler);
                return null;
            }
        });
    }

    protected void start(FailureHandler failureHandler) throws Exception {
        Throwable error;
        do {
            if ((error = this.doStart()) != null) continue;
            return;
        } while (failureHandler.handle(error) != FailureHandler.Outcome.ABORT);
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new Exception(error);
    }

    private Throwable doStart() throws Exception {
        Assert.notNull((Object)this.mainClassName, (String)"Unable to find the main class to restart");
        ClassLoader parent = this.applicationClassLoader;
        URL[] urls = this.urls.toArray(new URL[this.urls.size()]);
        ClassLoaderFiles updatedFiles = new ClassLoaderFiles(this.classLoaderFiles);
        RestartClassLoader classLoader = new RestartClassLoader(parent, urls, updatedFiles, this.logger);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting application " + this.mainClassName + " with URLs " + Arrays.asList(urls)));
        }
        return this.relaunch(classLoader);
    }

    protected Throwable relaunch(ClassLoader classLoader) throws Exception {
        RestartLauncher launcher = new RestartLauncher(classLoader, this.mainClassName, this.args, this.exceptionHandler);
        launcher.start();
        launcher.join();
        return launcher.getError();
    }

    protected void stop() throws Exception {
        this.logger.debug((Object)"Stopping application");
        this.stopLock.lock();
        try {
            this.triggerShutdownHooks();
            this.cleanupCaches();
            if (this.forceReferenceCleanup) {
                this.forceReferenceCleanup();
            }
        }
        finally {
            this.stopLock.unlock();
        }
        System.gc();
        System.runFinalization();
    }

    private void triggerShutdownHooks() throws Exception {
        Class<?> hooksClass = Class.forName("java.lang.ApplicationShutdownHooks");
        Method runHooks = hooksClass.getDeclaredMethod("runHooks", new Class[0]);
        runHooks.setAccessible(true);
        runHooks.invoke(null, new Object[0]);
        Field field = hooksClass.getDeclaredField("hooks");
        field.setAccessible(true);
        field.set(null, new IdentityHashMap());
    }

    private void cleanupCaches() throws Exception {
        Introspector.flushCaches();
        this.cleanupKnownCaches();
    }

    private void cleanupKnownCaches() throws Exception {
        this.clear(ResolvableType.class, "cache");
        this.clear("org.springframework.core.SerializableTypeWrapper", "cache");
        this.clear(CachedIntrospectionResults.class, "acceptedClassLoaders");
        this.clear(CachedIntrospectionResults.class, "strongClassCache");
        this.clear(CachedIntrospectionResults.class, "softClassCache");
        this.clear(ReflectionUtils.class, "declaredFieldsCache");
        this.clear(ReflectionUtils.class, "declaredMethodsCache");
        this.clear(AnnotationUtils.class, "findAnnotationCache");
        this.clear(AnnotationUtils.class, "annotatedInterfaceCache");
        this.clear("com.sun.naming.internal.ResourceManager", "propertiesCache");
    }

    private void clear(String className, String fieldName) {
        try {
            this.clear(Class.forName(className), fieldName);
        }
        catch (Exception ex) {
            this.logger.debug((Object)("Unable to clear field " + className + " " + fieldName), (Throwable)ex);
        }
    }

    private void clear(Class<?> type, String fieldName) throws Exception {
        Field field = type.getDeclaredField(fieldName);
        field.setAccessible(true);
        Object instance = field.get(null);
        if (instance instanceof Set) {
            ((Set)instance).clear();
        }
        if (instance instanceof Map) {
            Map map = (Map)instance;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (!(value instanceof Class) || !(((Class)value).getClassLoader() instanceof RestartClassLoader)) continue;
                iterator.remove();
            }
        }
    }

    private void forceReferenceCleanup() {
        try {
            LinkedList<long[]> memory = new LinkedList<long[]>();
            while (true) {
                memory.add(new long[102400]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return;
        }
    }

    synchronized void finish() {
        if (!this.isFinished()) {
            this.logger = DeferredLog.replay((Log)this.logger, (Log)LogFactory.getLog(this.getClass()));
            this.finished = true;
        }
    }

    boolean isFinished() {
        return this.finished;
    }

    private LeakSafeThread getLeakSafeThread() {
        try {
            return this.leakSafeThreads.takeFirst();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrAddAttribute(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (!this.attributes.containsKey(name)) {
                this.attributes.put(name, objectFactory.getObject());
            }
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(name);
        }
    }

    public URL[] getInitialUrls() {
        return this.initialUrls;
    }

    public static void disable() {
        Restarter.initialize(NO_ARGS, false, RestartInitializer.NONE);
        Restarter.getInstance().setEnabled(false);
    }

    public static void initialize(String[] args) {
        Restarter.initialize(args, false, new DefaultRestartInitializer());
    }

    public static void initialize(String[] args, RestartInitializer initializer) {
        Restarter.initialize(args, false, initializer, true);
    }

    public static void initialize(String[] args, boolean forceReferenceCleanup) {
        Restarter.initialize(args, forceReferenceCleanup, new DefaultRestartInitializer());
    }

    public static void initialize(String[] args, boolean forceReferenceCleanup, RestartInitializer initializer) {
        Restarter.initialize(args, forceReferenceCleanup, initializer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(String[] args, boolean forceReferenceCleanup, RestartInitializer initializer, boolean restartOnInitialize) {
        if (instance != null) return;
        Class<Restarter> clazz = Restarter.class;
        synchronized (Restarter.class) {
            instance = new Restarter(Thread.currentThread(), args, forceReferenceCleanup, initializer);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            instance.initialize(restartOnInitialize);
            return;
        }
    }

    public static synchronized Restarter getInstance() {
        Assert.state((instance != null ? 1 : 0) != 0, (String)"Restarter has not been initialized");
        return instance;
    }

    static final void setInstance(Restarter instance) {
        Restarter.instance = instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    private class LeakSafeThreadFactory
    implements ThreadFactory {
        private LeakSafeThreadFactory() {
        }

        @Override
        public Thread newThread(final Runnable runnable) {
            return Restarter.this.getLeakSafeThread().callAndWait(new Callable<Thread>(){

                @Override
                public Thread call() throws Exception {
                    Thread thread = new Thread(runnable);
                    thread.setContextClassLoader(Restarter.this.applicationClassLoader);
                    return thread;
                }
            });
        }
    }

    private class LeakSafeThread
    extends Thread {
        private Callable<?> callable;
        private Object result;

        public LeakSafeThread() {
            this.setDaemon(false);
        }

        public void call(Callable<?> callable) {
            this.callable = callable;
            this.start();
        }

        public <V> V callAndWait(Callable<V> callable) {
            this.callable = callable;
            this.start();
            try {
                this.join();
                return (V)this.result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void run() {
            try {
                Restarter.this.leakSafeThreads.put(new LeakSafeThread());
                this.result = this.callable.call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }
}

