/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.server;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.devtools.restart.server.SourceFolderUrlFilter;
import org.springframework.util.StringUtils;

public class DefaultSourceFolderUrlFilter
implements SourceFolderUrlFilter {
    private static final String[] COMMON_ENDINGS = new String[]{"/target/classes", "/bin"};
    private static final Pattern URL_MODULE_PATTERN = Pattern.compile(".*\\/(.+)\\.jar");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^-\\d+(?:\\.\\d+)*(?:[.-].+)?$");

    @Override
    public boolean isMatch(String sourceFolder, URL url) {
        String jarName = this.getJarName(url);
        if (!StringUtils.hasLength((String)jarName)) {
            return false;
        }
        return this.isMatch(sourceFolder, jarName);
    }

    private String getJarName(URL url) {
        Matcher matcher = URL_MODULE_PATTERN.matcher(url.toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isMatch(String sourceFolder, String jarName) {
        sourceFolder = this.stripTrailingSlash(sourceFolder);
        sourceFolder = this.stripCommonEnds(sourceFolder);
        String[] folders = StringUtils.delimitedListToStringArray((String)sourceFolder, (String)"/");
        for (int i = folders.length - 1; i >= 0; --i) {
            if (!this.isFolderMatch(folders[i], jarName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFolderMatch(String folder, String jarName) {
        if (!jarName.startsWith(folder)) {
            return false;
        }
        String version = jarName.substring(folder.length());
        return version.isEmpty() || VERSION_PATTERN.matcher(version).matches();
    }

    private String stripTrailingSlash(String string) {
        if (string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String stripCommonEnds(String string) {
        for (String ending : COMMON_ENDINGS) {
            if (!string.endsWith(ending)) continue;
            return string.substring(0, string.length() - ending.length());
        }
        return string;
    }
}

