/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFF)
public class DevToolsPropertyDefaultsPostProcessor
implements EnvironmentPostProcessor {
    private static final Map<String, Object> PROPERTIES;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isLocalApplication(environment)) {
            MapPropertySource propertySource = new MapPropertySource("refresh", PROPERTIES);
            environment.getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    private boolean isLocalApplication(ConfigurableEnvironment environment) {
        return environment.getPropertySources().get("remoteUrl") == null;
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.thymeleaf.cache", "false");
        properties.put("spring.freemarker.cache", "false");
        properties.put("spring.groovy.template.cache", "false");
        properties.put("spring.velocity.cache", "false");
        properties.put("spring.mustache.cache", "false");
        properties.put("server.session.persistent", "true");
        properties.put("spring.h2.console.enabled", "true");
        properties.put("spring.resources.cache-period", "0");
        PROPERTIES = Collections.unmodifiableMap(properties);
    }
}

