/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.DevToolsEnablementDeducer;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class DevToolsHomePropertiesPostProcessor
implements EnvironmentPostProcessor {
    private static final String LEGACY_FILE_NAME = ".spring-boot-devtools.properties";
    private static final String[] FILE_NAMES = new String[]{".spring-boot-devtools.yml", ".spring-boot-devtools.yaml", ".spring-boot-devtools.properties"};
    private static final String CONFIG_PATH = "/.config/spring-boot/";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (DevToolsEnablementDeducer.shouldEnable(Thread.currentThread())) {
            List<PropertySource> propertySources = this.getPropertySources();
            if (propertySources.isEmpty()) {
                this.addPropertySource(LEGACY_FILE_NAME, file -> "devtools-local", propertySources);
            }
            propertySources.forEach(source -> environment.getPropertySources().addFirst(source));
        }
    }

    private List<PropertySource> getPropertySources() {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (String fileName : FILE_NAMES) {
            this.addPropertySource(CONFIG_PATH + fileName, file -> "devtools-local: [" + file.toURI() + "]", propertySources);
        }
        return propertySources;
    }

    private void addPropertySource(String fileName, Function<File, String> propertySourceName, List<PropertySource> propertySources) {
        File propertyFile;
        File home = this.getHomeFolder();
        File file = propertyFile = home != null ? new File(home, fileName) : null;
        if (propertyFile != null && propertyFile.exists() && propertyFile.isFile()) {
            FileSystemResource resource = new FileSystemResource(propertyFile);
            try {
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                propertySources.add((PropertySource)new PropertiesPropertySource(propertySourceName.apply(propertyFile), properties));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to load " + fileName, ex);
            }
        }
    }

    protected File getHomeFolder() {
        String home = System.getProperty("user.home");
        if (StringUtils.hasLength((String)home)) {
            return new File(home);
        }
        return null;
    }
}

