/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.function.Function;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.GUtil;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.FileUtils;

class BootZipCopyAction
implements CopyAction {
    private final File output;
    private final boolean preserveFileTimestamps;
    private final boolean includeDefaultLoader;
    private final Spec<FileTreeElement> requiresUnpack;
    private final Spec<FileTreeElement> exclusions;
    private final LaunchScriptConfiguration launchScript;
    private final Function<FileCopyDetails, ZipCompression> compressionResolver;

    BootZipCopyAction(File output, boolean preserveFileTimestamps, boolean includeDefaultLoader, Spec<FileTreeElement> requiresUnpack, Spec<FileTreeElement> exclusions, LaunchScriptConfiguration launchScript, Function<FileCopyDetails, ZipCompression> compressionResolver) {
        this.output = output;
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.includeDefaultLoader = includeDefaultLoader;
        this.requiresUnpack = requiresUnpack;
        this.exclusions = exclusions;
        this.launchScript = launchScript;
        this.compressionResolver = compressionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(CopyActionProcessingStream stream) {
        Spec<FileTreeElement> loaderEntries;
        ZipOutputStream zipStream;
        try {
            FileOutputStream fileStream = new FileOutputStream(this.output);
            this.writeLaunchScriptIfNecessary(fileStream);
            zipStream = new ZipOutputStream(fileStream);
            loaderEntries = this.writeLoaderClassesIfNecessary(zipStream);
        }
        catch (IOException ex) {
            throw new GradleException("Failed to create " + this.output, (Throwable)ex);
        }
        try {
            stream.process((CopyActionProcessingStreamAction)new ZipStreamAction(zipStream, this.output, this.preserveFileTimestamps, this.requiresUnpack, this.createExclusionSpec(loaderEntries), this.compressionResolver));
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException iOException) {}
        }
        return () -> true;
    }

    private Spec<FileTreeElement> createExclusionSpec(Spec<FileTreeElement> loaderEntries) {
        return Specs.union((Spec[])new Spec[]{loaderEntries, this.exclusions});
    }

    private Spec<FileTreeElement> writeLoaderClassesIfNecessary(ZipOutputStream out) {
        if (!this.includeDefaultLoader) {
            return Specs.satisfyNone();
        }
        return this.writeLoaderClasses(out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Spec<FileTreeElement> writeLoaderClasses(ZipOutputStream out) {
        try (ZipInputStream in = new ZipInputStream(this.getClass().getResourceAsStream("/META-INF/loader/spring-boot-loader.jar"));){
            ZipEntry entry;
            HashSet<String> entries = new HashSet<String>();
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory() && !entry.getName().startsWith("META-INF/")) {
                    this.writeDirectory(entry, out);
                    entries.add(entry.getName());
                    continue;
                }
                if (!entry.getName().endsWith(".class")) continue;
                this.writeClass(entry, in, out);
            }
            Spec spec = element -> {
                String path = element.getRelativePath().getPathString();
                if (element.isDirectory() && !path.endsWith("/")) {
                    path = path + "/";
                }
                return entries.contains(path);
            };
            return spec;
        }
        catch (IOException ex) {
            throw new GradleException("Failed to write loader classes", (Throwable)ex);
        }
    }

    private void writeDirectory(ZipEntry entry, ZipOutputStream out) throws IOException {
        if (!this.preserveFileTimestamps) {
            entry.setTime(GUtil.CONSTANT_TIME_FOR_ZIP_ENTRIES);
        }
        out.putNextEntry(entry);
        out.closeEntry();
    }

    private void writeClass(ZipEntry entry, ZipInputStream in, ZipOutputStream out) throws IOException {
        int read;
        if (!this.preserveFileTimestamps) {
            entry.setTime(GUtil.CONSTANT_TIME_FOR_ZIP_ENTRIES);
        }
        out.putNextEntry(entry);
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        out.closeEntry();
    }

    private void writeLaunchScriptIfNecessary(FileOutputStream fileStream) {
        try {
            if (this.launchScript.isIncluded()) {
                fileStream.write(new DefaultLaunchScript(this.launchScript.getScript(), this.launchScript.getProperties()).toByteArray());
            }
        }
        catch (IOException ex) {
            throw new GradleException("Failed to write launch script to " + this.output, (Throwable)ex);
        }
    }

    private static final class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc32 = new CRC32();

        private Crc32OutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.crc32.update(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.crc32.update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.crc32.update(b, off, len);
        }

        private long getCrc() {
            return this.crc32.getValue();
        }
    }

    private static final class ZipStreamAction
    implements CopyActionProcessingStreamAction {
        private final ZipOutputStream zipStream;
        private final File output;
        private final boolean preserveFileTimestamps;
        private final Spec<FileTreeElement> requiresUnpack;
        private final Spec<FileTreeElement> exclusions;
        private final Function<FileCopyDetails, ZipCompression> compressionType;

        private ZipStreamAction(ZipOutputStream zipStream, File output, boolean preserveFileTimestamps, Spec<FileTreeElement> requiresUnpack, Spec<FileTreeElement> exclusions, Function<FileCopyDetails, ZipCompression> compressionType) {
            this.zipStream = zipStream;
            this.output = output;
            this.preserveFileTimestamps = preserveFileTimestamps;
            this.requiresUnpack = requiresUnpack;
            this.exclusions = exclusions;
            this.compressionType = compressionType;
        }

        public void processFile(FileCopyDetailsInternal details) {
            if (this.exclusions.isSatisfiedBy((Object)details)) {
                return;
            }
            try {
                if (details.isDirectory()) {
                    this.createDirectory(details);
                } else {
                    this.createFile(details);
                }
            }
            catch (IOException ex) {
                throw new GradleException("Failed to add " + details + " to " + this.output, (Throwable)ex);
            }
        }

        private void createDirectory(FileCopyDetailsInternal details) throws IOException {
            ZipEntry archiveEntry = new ZipEntry(details.getRelativePath().getPathString() + '/');
            archiveEntry.setTime(this.getTime((FileCopyDetails)details));
            this.zipStream.putNextEntry(archiveEntry);
            this.zipStream.closeEntry();
        }

        private void createFile(FileCopyDetailsInternal details) throws IOException {
            String relativePath = details.getRelativePath().getPathString();
            ZipEntry archiveEntry = new ZipEntry(relativePath);
            archiveEntry.setTime(this.getTime((FileCopyDetails)details));
            ZipCompression compression = this.compressionType.apply((FileCopyDetails)details);
            if (compression == ZipCompression.STORED) {
                this.prepareStoredEntry(details, archiveEntry);
            }
            this.zipStream.putNextEntry(archiveEntry);
            details.copyTo((OutputStream)this.zipStream);
            this.zipStream.closeEntry();
        }

        private void prepareStoredEntry(FileCopyDetailsInternal details, ZipEntry archiveEntry) throws IOException {
            archiveEntry.setMethod(0);
            archiveEntry.setSize(details.getSize());
            archiveEntry.setCompressedSize(details.getSize());
            Crc32OutputStream crcStream = new Crc32OutputStream();
            details.copyTo((OutputStream)crcStream);
            archiveEntry.setCrc(crcStream.getCrc());
            if (this.requiresUnpack.isSatisfiedBy((Object)details)) {
                archiveEntry.setComment("UNPACK:" + FileUtils.sha1Hash((File)details.getFile()));
            }
        }

        private long getTime(FileCopyDetails details) {
            return this.preserveFileTimestamps ? details.getLastModified() : GUtil.CONSTANT_TIME_FOR_ZIP_ENTRIES;
        }
    }
}

