/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.run;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class BootRun
extends DefaultTask {
    private final PropertyState<String> main = this.getProject().property(String.class);
    private final PropertyState<List<String>> jvmArgs = this.getProject().property(List.class);
    private final PropertyState<List<String>> args = this.getProject().property(List.class);
    private FileCollection classpath = this.getProject().files(new Object[0]);
    private List<Action<JavaExecSpec>> execSpecConfigurers = new ArrayList<Action<JavaExecSpec>>();

    public void classpath(Object ... entries) {
        this.classpath = this.classpath.plus((FileCollection)this.getProject().files(entries));
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void sourceResources(SourceSet sourceSet) {
        this.classpath = this.getProject().files(new Object[]{sourceSet.getResources().getSrcDirs(), this.classpath}).filter(file -> !file.equals(sourceSet.getOutput().getResourcesDir()));
    }

    public String getMain() {
        return (String)this.main.getOrNull();
    }

    public void setMain(Provider<String> mainProvider) {
        this.main.set(mainProvider);
    }

    public void setMain(String main) {
        this.main.set((Object)main);
    }

    public List<String> getJvmArgs() {
        return (List)this.jvmArgs.getOrNull();
    }

    public void setJvmArgs(Provider<List<String>> jvmArgsProvider) {
        this.jvmArgs.set(jvmArgsProvider);
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs.set(jvmArgs);
    }

    public List<String> getArgs() {
        return (List)this.args.getOrNull();
    }

    public void setArgs(List<String> args) {
        this.args.set(args);
    }

    public void setArgs(Provider<List<String>> argsProvider) {
        this.args.set(argsProvider);
    }

    public void execSpec(Action<JavaExecSpec> execSpecConfigurer) {
        this.execSpecConfigurers.add(execSpecConfigurer);
    }

    @TaskAction
    public void run() {
        this.getProject().javaexec(spec -> {
            spec.classpath(new Object[]{this.classpath});
            spec.setMain((String)this.main.getOrNull());
            if (this.jvmArgs.isPresent()) {
                spec.setJvmArgs((List)this.jvmArgs.get());
            }
            if (this.args.isPresent()) {
                spec.setArgs((List)this.args.get());
            }
            if (System.console() != null) {
                spec.environment("spring.output.ansi.console-available", (Object)true);
            }
            this.execSpecConfigurers.forEach(configurer -> configurer.execute(spec));
        });
    }
}

