/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.dsl.SpringBootExtension;
import org.springframework.boot.gradle.plugin.ApplicationPluginAction;
import org.springframework.boot.gradle.plugin.DependencyManagementPluginAction;
import org.springframework.boot.gradle.plugin.JavaPluginAction;
import org.springframework.boot.gradle.plugin.MavenPluginAction;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.plugin.UnresolvedDependenciesAnalyzer;
import org.springframework.boot.gradle.plugin.WarPluginAction;

public class SpringBootPlugin
implements Plugin<Project> {
    public static final String BOOT_ARCHIVES_CONFIGURATION_NAME = "bootArchives";
    public static final String BOOT_JAR_TASK_NAME = "bootJar";
    public static final String BOOT_WAR_TASK_NAME = "bootWar";

    public void apply(Project project) {
        this.verifyGradleVersion();
        this.createExtension(project);
        Configuration bootArchives = this.createBootArchivesConfiguration(project);
        this.registerPluginActions(project, bootArchives);
        this.unregisterUnresolvedDependenciesAnalyzer(project);
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) < 0) {
            throw new GradleException("Spring Boot plugin requires Gradle 4.0 or later. The current version is " + GradleVersion.current());
        }
    }

    private void createExtension(Project project) {
        project.getExtensions().create("springBoot", SpringBootExtension.class, new Object[]{project});
    }

    private Configuration createBootArchivesConfiguration(Project project) {
        Configuration bootArchives = (Configuration)project.getConfigurations().create(BOOT_ARCHIVES_CONFIGURATION_NAME);
        bootArchives.setDescription("Configuration for Spring Boot archive artifacts.");
        return bootArchives;
    }

    private void registerPluginActions(Project project, Configuration bootArchives) {
        SinglePublishedArtifact singlePublishedArtifact = new SinglePublishedArtifact(bootArchives.getArtifacts());
        List<PluginApplicationAction> actions = Arrays.asList(new JavaPluginAction(singlePublishedArtifact), new WarPluginAction(singlePublishedArtifact), new MavenPluginAction(bootArchives.getUploadTaskName()), new DependencyManagementPluginAction(), new ApplicationPluginAction());
        for (PluginApplicationAction action : actions) {
            project.getPlugins().withType(action.getPluginClass(), plugin -> action.execute(project));
        }
    }

    private void unregisterUnresolvedDependenciesAnalyzer(Project project) {
        UnresolvedDependenciesAnalyzer unresolvedDependenciesAnalyzer = new UnresolvedDependenciesAnalyzer();
        project.getConfigurations().all(configuration -> configuration.getIncoming().afterResolve(resolvableDependencies -> unresolvedDependenciesAnalyzer.analyze(configuration.getResolvedConfiguration().getLenientConfiguration().getUnresolvedModuleDependencies())));
        project.getGradle().buildFinished(buildResult -> unresolvedDependenciesAnalyzer.buildFinished(project));
    }
}

