/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.cyclonedx.gradle.CycloneDxPlugin;
import org.cyclonedx.gradle.CycloneDxTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.tasks.bundling.BootJar;

final class CycloneDxPluginAction
implements PluginApplicationAction {
    CycloneDxPluginAction() {
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return CycloneDxPlugin.class;
    }

    public void execute(Project project) {
        TaskProvider cyclonedxBom = project.getTasks().named("cyclonedxBom", CycloneDxTask.class);
        cyclonedxBom.configure(task -> {
            task.getProjectType().convention((Object)"application");
            task.getOutputFormat().convention((Object)"json");
            task.getOutputName().convention((Object)"application.cdx");
            task.getIncludeLicenseText().convention((Object)false);
        });
        project.getTasks().named("bootJar", BootJar.class).configure(bootJar -> {
            CycloneDxTask cycloneDxTask = (CycloneDxTask)cyclonedxBom.get();
            String sbomFileName = (String)cycloneDxTask.getOutputName().get() + this.getSbomExtension(cycloneDxTask);
            bootJar.from(cycloneDxTask, spec -> spec.include(new String[]{sbomFileName}).into((Object)"META-INF/sbom"));
            bootJar.manifest(manifest -> {
                manifest.getAttributes().put((Object)"Sbom-Format", (Object)"CycloneDX");
                manifest.getAttributes().put((Object)"Sbom-Location", (Object)("META-INF/sbom/" + sbomFileName));
            });
        });
    }

    private String getSbomExtension(CycloneDxTask task) {
        String format = (String)task.getOutputFormat().get();
        if ("all".equals(format)) {
            return ".json";
        }
        return "." + format;
    }
}

