/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.Iterator;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.CompositeReactiveHealthContributors;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.HealthContributorsAdapter;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributorsAdapter;
import org.springframework.util.Assert;

public interface ReactiveHealthContributors
extends Iterable<Entry> {
    public ReactiveHealthContributor getContributor(String var1);

    @Override
    default public Iterator<Entry> iterator() {
        return this.stream().iterator();
    }

    public Stream<Entry> stream();

    default public HealthContributors asHealthContributors() {
        return new ReactiveHealthContributorsAdapter(this);
    }

    public static ReactiveHealthContributors of(ReactiveHealthContributors ... contributors) {
        return new CompositeReactiveHealthContributors(contributors);
    }

    public static ReactiveHealthContributors adapt(HealthContributors contributors) {
        return contributors != null ? new HealthContributorsAdapter(contributors) : null;
    }

    public record Entry(String name, ReactiveHealthContributor contributor) {
        public Entry {
            Assert.hasText((String)name, (String)"'name' must not be empty");
            Assert.notNull((Object)contributor, (String)"'contributor' must not be null");
        }
    }
}

