/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;

public record ClientHttpRequestFactorySettings(HttpRedirects redirects, Duration connectTimeout, Duration readTimeout, SslBundle sslBundle) {
    private static final ClientHttpRequestFactorySettings defaults = new ClientHttpRequestFactorySettings(null, null, null, null);

    public ClientHttpRequestFactorySettings(HttpRedirects redirects, Duration connectTimeout, Duration readTimeout, SslBundle sslBundle) {
        this.redirects = redirects = redirects != null ? redirects : HttpRedirects.FOLLOW_WHEN_POSSIBLE;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.sslBundle = sslBundle;
    }

    public ClientHttpRequestFactorySettings withConnectTimeout(Duration connectTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, this.readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withReadTimeout(Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withTimeouts(Duration connectTimeout, Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withSslBundle(SslBundle sslBundle) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, this.readTimeout, sslBundle);
    }

    public ClientHttpRequestFactorySettings withRedirects(HttpRedirects redirects) {
        return new ClientHttpRequestFactorySettings(redirects, this.connectTimeout, this.readTimeout, this.sslBundle);
    }

    public static ClientHttpRequestFactorySettings ofSslBundle(SslBundle sslBundle) {
        return ClientHttpRequestFactorySettings.defaults().withSslBundle(sslBundle);
    }

    public static ClientHttpRequestFactorySettings defaults() {
        return defaults;
    }
}

