/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.observation.autoconfigure.ObservationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(afterName={"org.springframework.boot.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnClass(value={ObservationProperties.class, MeterRegistry.class, MetricsProperties.class})
@ConditionalOnBean(value={MeterRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class HttpClientMetricsAutoConfiguration {
    @Bean
    @Order(value=0)
    MeterFilter metricsHttpClientUriTagFilter(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
        MetricsProperties.Web.Client clientProperties = metricsProperties.getWeb().getClient();
        String name = observationProperties.getHttp().getClient().getRequests().getName();
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> "Reached the maximum number of URI tags for '%s'. Are you using 'uriVariables'?".formatted(name));
        return MeterFilter.maximumAllowableTags((String)name, (String)"uri", (int)clientProperties.getMaxUriTags(), (MeterFilter)denyFilter);
    }
}

