/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;

@ConfigurationProperties(value="spring.http.clients.reactive")
public class ReactiveHttpClientsProperties {
    private @Nullable Connector connector;

    public @Nullable Connector getConnector() {
        return this.connector;
    }

    public void setConnector(@Nullable Connector connector) {
        this.connector = connector;
    }

    public static enum Connector {
        REACTOR(ClientHttpConnectorBuilder::reactor),
        JETTY(ClientHttpConnectorBuilder::jetty),
        HTTP_COMPONENTS(ClientHttpConnectorBuilder::httpComponents),
        JDK(ClientHttpConnectorBuilder::jdk);

        private final Supplier<ClientHttpConnectorBuilder<?>> builderSupplier;

        private Connector(Supplier<ClientHttpConnectorBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpConnectorBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

