/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.springframework.boot.jarmode.tools.Command;
import org.springframework.boot.jarmode.tools.Context;
import org.springframework.boot.jarmode.tools.Layers;

class ListLayersCommand
extends Command {
    private final Context context;

    ListLayersCommand(Context context) {
        super("list-layers", "List layers from the jar that can be extracted", Command.Options.none(), Command.Parameters.none());
        this.context = context;
    }

    @Override
    void run(PrintStream out, Map<Command.Option, String> options, List<String> parameters) {
        try {
            Layers layers = Layers.get(this.context);
            this.printLayers(out, layers);
        }
        catch (Layers.LayersNotEnabledException ex) {
            this.printError(out, "Layers are not enabled");
        }
    }

    void printLayers(PrintStream out, Layers layers) {
        layers.forEach(out::println);
    }

    private void printError(PrintStream out, String message) {
        out.println("Error: " + message);
        out.println();
    }
}

