/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class JdbcUrlBuilder {
    private static final String PARAMETERS_LABEL = "org.springframework.boot.jdbc.parameters";
    private final String driverProtocol;
    private final int containerPort;

    JdbcUrlBuilder(String driverProtocol, int containerPort) {
        Assert.notNull((Object)driverProtocol, (String)"'driverProtocol' must not be null");
        this.driverProtocol = driverProtocol;
        this.containerPort = containerPort;
    }

    String build(RunningService service) {
        return this.build(service, null);
    }

    String build(RunningService service, @Nullable String database) {
        return this.urlFor(service, database);
    }

    private String urlFor(RunningService service, @Nullable String database) {
        String parameters;
        Assert.notNull((Object)service, (String)"'service' must not be null");
        StringBuilder url = new StringBuilder("jdbc:%s://%s:%d".formatted(this.driverProtocol, service.host(), service.ports().get(this.containerPort)));
        if (StringUtils.hasLength((String)database)) {
            url.append("/");
            url.append(database);
        }
        if (StringUtils.hasLength((String)(parameters = this.getParameters(service)))) {
            this.appendParameters(url, parameters);
        }
        return url.toString();
    }

    protected void appendParameters(StringBuilder url, String parameters) {
        url.append("?").append(parameters);
    }

    private @Nullable String getParameters(RunningService service) {
        return (String)service.labels().get(PARAMETERS_LABEL);
    }
}

