/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class EmbeddedDataSourceConfiguration
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Bean(destroyMethod="shutdown")
    EmbeddedDatabase dataSource(DataSourceProperties properties) {
        EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(this.classLoader).getType();
        String databaseName = properties.determineDatabaseName();
        Assert.state((type != null ? 1 : 0) != 0, (String)"'type' must not be null");
        Assert.state((databaseName != null ? 1 : 0) != 0, (String)"'databaseName' must not be null");
        return new EmbeddedDatabaseBuilder().setType(type).setName(databaseName).build();
    }
}

