/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.autoconfigure.PropertiesJdbcConnectionDetails;
import org.springframework.core.PriorityOrdered;

abstract class JdbcConnectionDetailsBeanPostProcessor<T>
implements BeanPostProcessor,
PriorityOrdered {
    private final Class<T> dataSourceClass;
    private final ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider;

    JdbcConnectionDetailsBeanPostProcessor(Class<T> dataSourceClass, ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
        this.dataSourceClass = dataSourceClass;
        this.connectionDetailsProvider = connectionDetailsProvider;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        JdbcConnectionDetails connectionDetails;
        if (this.dataSourceClass.isAssignableFrom(bean.getClass()) && "dataSource".equals(beanName) && !((connectionDetails = (JdbcConnectionDetails)this.connectionDetailsProvider.getObject()) instanceof PropertiesJdbcConnectionDetails)) {
            return this.processDataSource(bean, connectionDetails);
        }
        return bean;
    }

    protected abstract Object processDataSource(T var1, JdbcConnectionDetails var2);

    public int getOrder() {
        return -2147483646;
    }
}

