/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure.actuate.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ext.ContextResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJackson2ObjectMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroups;
import org.springframework.boot.jersey.actuate.endpoint.web.JerseyEndpointResourceFactory;
import org.springframework.boot.jersey.actuate.endpoint.web.JerseyHealthEndpointAdditionalPathResourceFactory;
import org.springframework.boot.jersey.autoconfigure.ResourceConfigCustomizer;
import org.springframework.boot.jersey.autoconfigure.actuate.web.ManagementContextResourceConfigCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class})
@ConditionalOnBean(value={WebEndpointsSupplier.class})
@ConditionalOnMissingBean(type={"org.springframework.web.servlet.DispatcherServlet"})
class JerseyWebEndpointManagementContextConfiguration {
    private static final EndpointId HEALTH_ENDPOINT_ID = EndpointId.of((String)"health");

    JerseyWebEndpointManagementContextConfiguration() {
    }

    @Bean
    JerseyWebEndpointsResourcesRegistrar jerseyWebEndpointsResourcesRegistrar(Environment environment, WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, WebEndpointProperties webEndpointProperties) {
        String basePath = webEndpointProperties.getBasePath();
        boolean shouldRegisterLinks = this.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
        return new JerseyWebEndpointsResourcesRegistrar(webEndpointsSupplier, servletEndpointsSupplier, endpointMediaTypes, basePath, shouldRegisterLinks);
    }

    @Bean
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    @ConditionalOnBean(value={HealthEndpoint.class})
    @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
    JerseyAdditionalHealthEndpointPathsManagementResourcesRegistrar jerseyDifferentPortAdditionalHealthEndpointPathsResourcesRegistrar(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups healthEndpointGroups) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        ExposableWebEndpoint healthEndpoint = webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HEALTH_ENDPOINT_ID)).findFirst().orElse(null);
        return new JerseyAdditionalHealthEndpointPathsManagementResourcesRegistrar(healthEndpoint, healthEndpointGroups);
    }

    @Bean
    @ConditionalOnBean(value={EndpointJackson2ObjectMapper.class})
    ResourceConfigCustomizer endpointJackson2ObjectMapperResourceConfigCustomizer(EndpointJackson2ObjectMapper endpointJackson2ObjectMapper) {
        return config -> config.register((Object)new EndpointJackson2ObjectMapperContextResolver(endpointJackson2ObjectMapper), new Class[]{ContextResolver.class});
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties properties, Environment environment, String basePath) {
        return properties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment).equals((Object)ManagementPortType.DIFFERENT));
    }

    static class JerseyWebEndpointsResourcesRegistrar
    implements ManagementContextResourceConfigCustomizer {
        private final WebEndpointsSupplier webEndpointsSupplier;
        private final ServletEndpointsSupplier servletEndpointsSupplier;
        private final EndpointMediaTypes mediaTypes;
        private final String basePath;
        private final boolean shouldRegisterLinks;

        JerseyWebEndpointsResourcesRegistrar(WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, String basePath, boolean shouldRegisterLinks) {
            this.webEndpointsSupplier = webEndpointsSupplier;
            this.servletEndpointsSupplier = servletEndpointsSupplier;
            this.mediaTypes = endpointMediaTypes;
            this.basePath = basePath;
            this.shouldRegisterLinks = shouldRegisterLinks;
        }

        @Override
        public void customize(ResourceConfig config) {
            this.register(config);
        }

        private void register(ResourceConfig config) {
            Collection webEndpoints = this.webEndpointsSupplier.getEndpoints();
            Collection servletEndpoints = this.servletEndpointsSupplier.getEndpoints();
            EndpointLinksResolver linksResolver = this.getLinksResolver(webEndpoints, servletEndpoints);
            EndpointMapping mapping = new EndpointMapping(this.basePath);
            Collection<Resource> endpointResources = new JerseyEndpointResourceFactory().createEndpointResources(mapping, webEndpoints, this.mediaTypes, linksResolver, this.shouldRegisterLinks);
            this.register(endpointResources, config);
        }

        private EndpointLinksResolver getLinksResolver(Collection<ExposableWebEndpoint> webEndpoints, Collection<ExposableServletEndpoint> servletEndpoints) {
            ArrayList<Object> endpoints = new ArrayList<Object>(webEndpoints.size() + servletEndpoints.size());
            endpoints.addAll(webEndpoints);
            endpoints.addAll(servletEndpoints);
            return new EndpointLinksResolver(endpoints, this.basePath);
        }

        private void register(Collection<Resource> resources, ResourceConfig config) {
            config.registerResources(new HashSet<Resource>(resources));
        }
    }

    class JerseyAdditionalHealthEndpointPathsManagementResourcesRegistrar
    implements ManagementContextResourceConfigCustomizer {
        private final @Nullable ExposableWebEndpoint healthEndpoint;
        private final HealthEndpointGroups groups;

        JerseyAdditionalHealthEndpointPathsManagementResourcesRegistrar(ExposableWebEndpoint healthEndpoint, HealthEndpointGroups groups) {
            this.healthEndpoint = healthEndpoint;
            this.groups = groups;
        }

        @Override
        public void customize(ResourceConfig config) {
            if (this.healthEndpoint != null) {
                this.register(config, this.healthEndpoint);
            }
        }

        private void register(ResourceConfig config, ExposableWebEndpoint healthEndpoint) {
            EndpointMapping mapping = new EndpointMapping("");
            JerseyHealthEndpointAdditionalPathResourceFactory resourceFactory = new JerseyHealthEndpointAdditionalPathResourceFactory(WebServerNamespace.MANAGEMENT, this.groups);
            List<Resource> endpointResources = resourceFactory.createEndpointResources(mapping, Collections.singletonList(healthEndpoint)).stream().filter(Objects::nonNull).toList();
            this.register(endpointResources, config);
        }

        private void register(Collection<Resource> resources, ResourceConfig config) {
            config.registerResources(new HashSet<Resource>(resources));
        }
    }

    @Priority(value=4900)
    private static final class EndpointJackson2ObjectMapperContextResolver
    implements ContextResolver<ObjectMapper> {
        private final EndpointJackson2ObjectMapper mapper;

        private EndpointJackson2ObjectMapperContextResolver(EndpointJackson2ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public @Nullable ObjectMapper getContext(Class<?> type) {
            return OperationResponseBody.class.isAssignableFrom(type) ? this.mapper.get() : null;
        }
    }
}

