/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;

public abstract class AgentAttacher {
    public static void attach(File agent) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.substring(0, name.indexOf(64));
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(agent.getAbsolutePath());
            vm.detach();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<String> commandLineArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static boolean hasNoVerify() {
        return AgentAttacher.commandLineArguments().contains("-Xverify:none");
    }
}

