/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.autoconfigure;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.boot.metrics.autoconfigure.MeterValue;
import org.springframework.boot.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.metrics.autoconfigure.ServiceLevelObjectiveBoundary;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMeterFilter
implements MeterFilter {
    private final MetricsProperties properties;
    private final MeterFilter mapFilter;

    public PropertiesMeterFilter(MetricsProperties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        this.properties = properties;
        this.mapFilter = PropertiesMeterFilter.createMapFilter(properties.getTags());
    }

    private static MeterFilter createMapFilter(Map<String, String> tags) {
        if (tags.isEmpty()) {
            return new MeterFilter(){};
        }
        Tags commonTags = Tags.of(tags.entrySet().stream().map(PropertiesMeterFilter::asTag).toList());
        return MeterFilter.commonTags((Iterable)commonTags);
    }

    private static Tag asTag(Map.Entry<String, String> entry) {
        return Tag.of((String)entry.getKey(), (String)entry.getValue());
    }

    public MeterFilterReply accept(Meter.Id id) {
        boolean enabled = this.lookupWithFallbackToAll(this.properties.getEnable(), id, true);
        return enabled ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
    }

    public Meter.Id map(Meter.Id id) {
        return this.mapFilter.map(id);
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        MetricsProperties.Distribution distribution = this.properties.getDistribution();
        return DistributionStatisticConfig.builder().percentilesHistogram((Boolean)this.lookupWithFallbackToAll(distribution.getPercentilesHistogram(), id, null)).percentiles((double[])this.lookupWithFallbackToAll(distribution.getPercentiles(), id, null)).serviceLevelObjectives(this.convertServiceLevelObjectives(id.getType(), this.lookup(distribution.getSlo(), id, null))).minimumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMinimumExpectedValue(), id, null))).maximumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMaximumExpectedValue(), id, null))).expiry((Duration)this.lookupWithFallbackToAll(distribution.getExpiry(), id, null)).bufferLength((Integer)this.lookupWithFallbackToAll(distribution.getBufferLength(), id, null)).build().merge(config);
    }

    private double[] convertServiceLevelObjectives(Meter.Type meterType, ServiceLevelObjectiveBoundary[] slo) {
        if (slo == null) {
            return null;
        }
        double[] converted = Arrays.stream(slo).map((? super T candidate) -> candidate.getValue(meterType)).filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
        return (double[])(converted.length != 0 ? converted : null);
    }

    private Double convertMeterValue(Meter.Type meterType, String value) {
        return value != null ? MeterValue.valueOf(value).getValue(meterType) : null;
    }

    private <T> T lookup(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> defaultValue);
    }

    private <T> T lookupWithFallbackToAll(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> values.getOrDefault("all", defaultValue));
    }

    private <T> T doLookup(Map<String, T> values, Meter.Id id, Supplier<T> defaultValue) {
        String name = id.getName();
        while (StringUtils.hasLength((String)name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return defaultValue.get();
    }
}

