/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.autoconfigure.export.otlp;

import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsProperties;
import org.springframework.boot.metrics.autoconfigure.export.properties.StepRegistryPropertiesConfigAdapter;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryProperties;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryResourceAttributes;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

class OtlpMetricsPropertiesConfigAdapter
extends StepRegistryPropertiesConfigAdapter<OtlpMetricsProperties>
implements OtlpConfig {
    private final OpenTelemetryProperties openTelemetryProperties;
    private final OtlpMetricsConnectionDetails connectionDetails;
    private final Environment environment;

    OtlpMetricsPropertiesConfigAdapter(OtlpMetricsProperties properties, OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment) {
        super(properties);
        this.connectionDetails = connectionDetails;
        this.openTelemetryProperties = openTelemetryProperties;
        this.environment = environment;
    }

    public String prefix() {
        return "management.otlp.metrics.export";
    }

    public String url() {
        return this.get(properties -> this.connectionDetails.getUrl(), () -> super.url());
    }

    public AggregationTemporality aggregationTemporality() {
        return this.get(OtlpMetricsProperties::getAggregationTemporality, () -> super.aggregationTemporality());
    }

    public Map<String, String> resourceAttributes() {
        LinkedHashMap resourceAttributes = new LinkedHashMap();
        new OpenTelemetryResourceAttributes(this.environment, this.openTelemetryProperties.getResourceAttributes()).applyTo(resourceAttributes::put);
        return Collections.unmodifiableMap(resourceAttributes);
    }

    public Map<String, String> headers() {
        return this.get(OtlpMetricsProperties::getHeaders, () -> super.headers());
    }

    public HistogramFlavor histogramFlavor() {
        return this.get(OtlpMetricsProperties::getHistogramFlavor, () -> super.histogramFlavor());
    }

    public Map<String, HistogramFlavor> histogramFlavorPerMeter() {
        return this.get(this.perMeter(OtlpMetricsProperties.Meter::getHistogramFlavor), () -> super.histogramFlavorPerMeter());
    }

    public Map<String, Integer> maxBucketsPerMeter() {
        return this.get(this.perMeter(OtlpMetricsProperties.Meter::getMaxBucketCount), () -> super.maxBucketsPerMeter());
    }

    public int maxScale() {
        return this.get(OtlpMetricsProperties::getMaxScale, () -> super.maxScale());
    }

    public int maxBucketCount() {
        return this.get(OtlpMetricsProperties::getMaxBucketCount, () -> super.maxBucketCount());
    }

    public TimeUnit baseTimeUnit() {
        return this.get(OtlpMetricsProperties::getBaseTimeUnit, () -> super.baseTimeUnit());
    }

    private <V> Function<OtlpMetricsProperties, Map<String, V>> perMeter(Function<OtlpMetricsProperties.Meter, V> getter) {
        return properties -> {
            if (CollectionUtils.isEmpty(properties.getMeter())) {
                return null;
            }
            LinkedHashMap perMeter = new LinkedHashMap();
            properties.getMeter().forEach((key, meterProperties) -> {
                Object value = getter.apply((OtlpMetricsProperties.Meter)meterProperties);
                if (value != null) {
                    perMeter.put(key, value);
                }
            });
            return !perMeter.isEmpty() ? perMeter : null;
        };
    }
}

