/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.docker.compose.otlp;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;

class OpenTelemetryMetricsDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpMetricsConnectionDetails> {
    private static final String[] OPENTELEMETRY_IMAGE_NAMES = new String[]{"otel/opentelemetry-collector-contrib", "grafana/otel-lgtm"};
    private static final int OTLP_PORT = 4318;

    OpenTelemetryMetricsDockerComposeConnectionDetailsFactory() {
        super(OPENTELEMETRY_IMAGE_NAMES, new String[]{"org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsExportAutoConfiguration"});
    }

    protected OtlpMetricsConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryMetricsDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryMetricsDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final String host;
        private final int port;

        private OpenTelemetryMetricsDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.port = source.ports().get(4318);
        }

        @Override
        public String getUrl() {
            return "http://%s:%d/v1/metrics".formatted(this.host, this.port);
        }
    }
}

