/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.testcontainers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.mssqlserver.MSSQLR2DBCDatabaseContainer;
import org.testcontainers.mssqlserver.MSSQLServerContainer;

class SqlServerR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MSSQLServerContainer, R2dbcConnectionDetails> {
    SqlServerR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MSSQLServerContainer> source) {
        return new MsSqlServerR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class MsSqlServerR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MSSQLServerContainer>
    implements R2dbcConnectionDetails {
        private MsSqlServerR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<MSSQLServerContainer> source) {
            super(source);
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MSSQLR2DBCDatabaseContainer.getOptions((MSSQLServerContainer)((MSSQLServerContainer)this.getContainer()));
        }
    }
}

