/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.List;
import org.springframework.boot.test.autoconfigure.OverrideAutoConfiguration;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class OverrideAutoConfigurationContextCustomizerFactory
implements ContextCustomizerFactory {
    OverrideAutoConfigurationContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configurationAttributes) {
        boolean enabled = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.EXHAUSTIVE).get(OverrideAutoConfiguration.class).getValue("enabled", Boolean.class).orElse(true);
        return !enabled ? new DisableAutoConfigurationContextCustomizer() : null;
    }

    private static class DisableAutoConfigurationContextCustomizer
    implements ContextCustomizer {
        private DisableAutoConfigurationContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            TestPropertyValues.of((String[])new String[]{"spring.boot.enableautoconfiguration=false"}).applyTo(context);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

