/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.boot.test.json.JsonLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonContentAssert
extends AbstractAssert<JsonContentAssert, CharSequence> {
    private final JsonLoader loader;

    public JsonContentAssert(Class<?> resourceLoadClass, CharSequence json) {
        super((Object)json, JsonContentAssert.class);
        this.loader = new JsonLoader(resourceLoadClass);
    }

    public JsonContentAssert isEqualTo(Object expected) {
        if (expected == null || expected instanceof CharSequence) {
            return this.isEqualToJson((CharSequence)expected);
        }
        if (expected instanceof byte[]) {
            return this.isEqualToJson((byte[])expected);
        }
        if (expected instanceof File) {
            return this.isEqualToJson((File)expected);
        }
        if (expected instanceof InputStream) {
            return this.isEqualToJson((InputStream)expected);
        }
        if (expected instanceof Resource) {
            return this.isEqualToJson((Resource)expected);
        }
        throw new AssertionError((Object)("Unsupport type for JSON assert " + expected.getClass()));
    }

    public JsonContentAssert isEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isStrictlyEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(byte[] expected) {
        return this.assertNotFailed(this.compare((CharSequence)this.loader.getJson(expected), JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isStrictlyEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isEqualToJson(CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(byte[] expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(File expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(InputStream expected, JSONCompareMode compareMode) {
        return this.assertNotFailed(this.compare((CharSequence)this.loader.getJson(expected), compareMode));
    }

    public JsonContentAssert isEqualToJson(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isEqualToJson(CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(String path, Class<?> resourceLoadClass, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(byte[] expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(File expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(InputStream expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isEqualToJson(Resource expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualTo(Object expected) {
        if (expected == null || expected instanceof CharSequence) {
            return this.isNotEqualToJson((CharSequence)expected);
        }
        if (expected instanceof byte[]) {
            return this.isNotEqualToJson((byte[])expected);
        }
        if (expected instanceof File) {
            return this.isNotEqualToJson((File)expected);
        }
        if (expected instanceof InputStream) {
            return this.isNotEqualToJson((InputStream)expected);
        }
        if (expected instanceof Resource) {
            return this.isNotEqualToJson((Resource)expected);
        }
        throw new AssertionError((Object)("Unsupport type for JSON assert " + expected.getClass()));
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected) {
        return this.assertNotPassed(this.compare((CharSequence)this.loader.getJson(expected), JSONCompareMode.LENIENT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(CharSequence expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(String path, Class<?> resourceLoadClass) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(byte[] expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(File expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(InputStream expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotStrictlyEqualToJson(Resource expected) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, JSONCompareMode.STRICT));
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(File expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public JsonContentAssert isNotEqualToJson(CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(String path, Class<?> resourceLoadClass, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(path, resourceLoadClass);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(byte[] expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(File expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(InputStream expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert isNotEqualToJson(Resource expected, JSONComparator comparator) {
        String expectedJson = this.loader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public JsonContentAssert hasJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Object.class, "an object");
        return this;
    }

    public JsonContentAssert hasJsonPathStringValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(String.class, "a string");
        return this;
    }

    public JsonContentAssert hasJsonPathNumberValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Number.class, "a number");
        return this;
    }

    public JsonContentAssert hasJsonPathBooleanValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Boolean.class, "a boolean");
        return this;
    }

    public JsonContentAssert hasJsonPathArrayValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(List.class, "an array");
        return this;
    }

    public JsonContentAssert hasJsonPathMapValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasValue(Map.class, "a map");
        return this;
    }

    public JsonContentAssert hasEmptyJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertHasEmptyValue();
        return this;
    }

    public JsonContentAssert doesNotHaveJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertDoesNotHaveValue();
        return this;
    }

    public JsonContentAssert doesNotHaveEmptyJsonPathValue(CharSequence expression, Object ... args) {
        new JsonPathValue(expression, args).assertDoesNotHaveEmptyValue();
        return this;
    }

    public AbstractObjectAssert<?, Object> extractingJsonPathValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((Object)new JsonPathValue(expression, args).getValue(false));
    }

    public AbstractCharSequenceAssert<?, String> extractingJsonPathStringValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((String)this.extractingJsonPathValue(expression, args, String.class, "a string"));
    }

    public AbstractObjectAssert<?, Number> extractingJsonPathNumberValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((Object)this.extractingJsonPathValue(expression, args, Number.class, "a number"));
    }

    public AbstractBooleanAssert<?> extractingJsonPathBooleanValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((Boolean)this.extractingJsonPathValue(expression, args, Boolean.class, "a boolean"));
    }

    public AbstractListAssert<?, ?, Object> extractingJsonPathArrayValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((List)this.extractingJsonPathValue(expression, args, List.class, "an array"));
    }

    public AbstractMapAssert<?, ?, Object, Object> extractingJsonPathMapValue(CharSequence expression, Object ... args) {
        return Assertions.assertThat((Map)this.extractingJsonPathValue(expression, args, Map.class, "a map"));
    }

    private <T> T extractingJsonPathValue(CharSequence expression, Object[] args, Class<T> type, String expectedDescription) {
        JsonPathValue value = new JsonPathValue(expression, args);
        if (value.getValue(false) != null) {
            value.assertHasValue(type, expectedDescription);
        }
        return (T)value.getValue(false);
    }

    private JSONCompareResult compare(CharSequence expectedJson, JSONCompareMode compareMode) {
        if (this.actual == null) {
            return this.compareForNull(expectedJson);
        }
        return JSONCompare.compareJSON((String)(expectedJson == null ? null : expectedJson.toString()), (String)((CharSequence)this.actual).toString(), (JSONCompareMode)compareMode);
    }

    private JSONCompareResult compare(CharSequence expectedJson, JSONComparator comparator) {
        if (this.actual == null) {
            return this.compareForNull(expectedJson);
        }
        return JSONCompare.compareJSON((String)(expectedJson == null ? null : expectedJson.toString()), (String)((CharSequence)this.actual).toString(), (JSONComparator)comparator);
    }

    private JSONCompareResult compareForNull(CharSequence expectedJson) {
        JSONCompareResult result = new JSONCompareResult();
        result.passed();
        if (expectedJson != null) {
            result.fail("Expected null JSON");
        }
        return result;
    }

    private JsonContentAssert assertNotFailed(JSONCompareResult result) {
        if (result.failed()) {
            throw new AssertionError((Object)("JSON Comparison failure: " + result.getMessage()));
        }
        return this;
    }

    private JsonContentAssert assertNotPassed(JSONCompareResult result) {
        if (result.passed()) {
            throw new AssertionError((Object)("JSON Comparison failure: " + result.getMessage()));
        }
        return this;
    }

    private class JsonPathValue {
        private final String expression;
        private final JsonPath jsonPath;

        JsonPathValue(CharSequence expression, Object ... args) {
            Assert.hasText((String)(expression == null ? null : expression.toString()), (String)"expression must not be null or empty");
            this.expression = String.format(expression.toString(), args);
            this.jsonPath = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
        }

        public void assertHasEmptyValue() {
            if (ObjectUtils.isEmpty((Object)this.getValue(false)) || this.isIndefiniteAndEmpty()) {
                return;
            }
            throw new AssertionError((Object)this.getExpectedValueMessage("an empty value"));
        }

        public void assertDoesNotHaveEmptyValue() {
            if (!ObjectUtils.isEmpty((Object)this.getValue(false))) {
                return;
            }
            throw new AssertionError((Object)this.getExpectedValueMessage("a non-empty value"));
        }

        public void assertHasValue(Class<?> type, String expectedDescription) {
            Object value = this.getValue(true);
            if (value == null || this.isIndefiniteAndEmpty()) {
                throw new AssertionError((Object)this.getNoValueMessage());
            }
            if (type != null && !type.isInstance(value)) {
                throw new AssertionError((Object)this.getExpectedValueMessage(expectedDescription));
            }
        }

        public void assertDoesNotHaveValue() {
            if (this.getValue(false) == null || this.isIndefiniteAndEmpty()) {
                return;
            }
            throw new AssertionError((Object)this.getExpectedValueMessage("no value"));
        }

        private boolean isIndefiniteAndEmpty() {
            return !this.isDefinite() && this.isEmpty();
        }

        private boolean isDefinite() {
            return this.jsonPath.isDefinite();
        }

        private boolean isEmpty() {
            return ObjectUtils.isEmpty((Object)this.getValue(false));
        }

        public Object getValue(boolean required) {
            try {
                CharSequence json = (CharSequence)JsonContentAssert.this.actual;
                return this.jsonPath.read(json == null ? null : json.toString());
            }
            catch (Exception ex) {
                if (!required) {
                    return null;
                }
                throw new AssertionError((Object)(this.getNoValueMessage() + ". " + ex.getMessage()));
            }
        }

        private String getNoValueMessage() {
            return "No value at JSON path \"" + this.expression + "\"";
        }

        private String getExpectedValueMessage(String expectedDescription) {
            return String.format("Expected %s at JSON path \"%s\" but found: %s", expectedDescription, this.expression, ObjectUtils.nullSafeToString((Object)StringUtils.quoteIfString((Object)this.getValue(false))));
        }
    }
}

