/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.net.URL;
import java.net.URLClassLoader;

public class HideClassesClassLoader
extends URLClassLoader {
    private final Class<?>[] hiddenClasses;

    public HideClassesClassLoader(Class<?> ... hiddenClasses) {
        super(new URL[0], HideClassesClassLoader.class.getClassLoader());
        this.hiddenClasses = hiddenClasses;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (Class<?> hiddenClass : this.hiddenClasses) {
            if (!name.equals(hiddenClass.getName())) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }
}

